/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.List;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class ListDeployedFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ListDeployedFunction.class.getName();
    private static final long serialVersionUID = 1L;

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            InternalCache cache = this.getCache();
            JarDeployer jarDeployer = ClassPathLoader.getLatest().getJarDeployer();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            List<DeployedJar> jarClassLoaders = jarDeployer.findDeployedJars();
            String[] jars = new String[jarClassLoaders.size() * 2];
            int index = 0;
            for (DeployedJar jarClassLoader : jarClassLoaders) {
                jars[index++] = jarClassLoader.getJarName();
                jars[index++] = jarClassLoader.getFileCanonicalPath();
            }
            CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])jars);
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not list JAR files: {}", (Object)th.getMessage(), (Object)th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

