/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.management.internal.cli.GfshParser;

public class CommandStringBuilder {
    private final String OPTION_MARKER = "--";
    private final String EQUAL_TO = "=";
    private final String ARG_SEPARATOR = " ";
    private final String OPTION_SEPARATOR = " ";
    private final String SINGLE_SPACE = " ";
    private final StringBuffer buffer;
    private volatile boolean hasOptions;

    public CommandStringBuilder(String command) {
        this.buffer = new StringBuffer(command);
    }

    private static String getLineSeparator() {
        if (SystemUtils.isWindows()) {
            return "\r";
        }
        return GfshParser.LINE_SEPARATOR;
    }

    public CommandStringBuilder addOption(String option, String value) {
        this.buffer.append(" ");
        this.buffer.append("--");
        this.buffer.append(option);
        this.buffer.append("=");
        this.buffer.append(value);
        this.hasOptions = true;
        return this;
    }

    public CommandStringBuilder addOptionWithValueCheck(String option, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            return this.addOption(option, value);
        }
        return this;
    }

    public CommandStringBuilder addOption(String option) {
        this.buffer.append(" ");
        this.buffer.append("--");
        this.buffer.append(option);
        this.hasOptions = true;
        return this;
    }

    public CommandStringBuilder addNewLine() {
        this.buffer.append(" ");
        this.buffer.append(CommandStringBuilder.getLineSeparator());
        return this;
    }

    public String getCommandString() {
        return this.buffer.toString();
    }

    public String toString() {
        return this.getCommandString();
    }
}

