/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.domain;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Configuration
implements DataSerializable {
    private static final long serialVersionUID = 1L;
    private String configName;
    private String cacheXmlContent;
    private String cacheXmlFileName;
    private String propertiesFileName;
    private Properties gemfireProperties;
    Set<String> jarNames;

    public Configuration() {
    }

    public Configuration(Configuration that) {
        this.configName = that.configName;
        this.cacheXmlContent = that.cacheXmlContent;
        this.cacheXmlFileName = that.cacheXmlFileName;
        this.propertiesFileName = that.propertiesFileName;
        this.gemfireProperties = new Properties();
        this.gemfireProperties.putAll((Map<?, ?>)that.gemfireProperties);
        this.jarNames = new HashSet<String>(that.jarNames);
    }

    public Configuration(String configName) {
        this.configName = configName;
        this.cacheXmlFileName = configName + ".xml";
        this.propertiesFileName = configName + ".properties";
        this.gemfireProperties = new Properties();
        this.jarNames = new HashSet<String>();
    }

    public String getCacheXmlContent() {
        return this.cacheXmlContent;
    }

    public void setCacheXmlContent(String cacheXmlContent) {
        this.cacheXmlContent = cacheXmlContent;
    }

    public void setCacheXmlFile(File cacheXmlFile) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        if (cacheXmlFile.length() == 0L) {
            this.cacheXmlContent = "";
        } else {
            Document doc = XmlUtils.getDocumentBuilder().parse(cacheXmlFile);
            this.cacheXmlContent = XmlUtils.elementToString(doc);
        }
    }

    public void setPropertiesFile(File propertiesFile) throws IOException {
        if (!propertiesFile.exists()) {
            return;
        }
        try (FileInputStream fis = null;){
            fis = new FileInputStream(propertiesFile);
            this.gemfireProperties.load(fis);
        }
    }

    public String getCacheXmlFileName() {
        return this.cacheXmlFileName;
    }

    public Properties getGemfireProperties() {
        return this.gemfireProperties;
    }

    public void setGemfireProperties(Properties gemfireProperties) {
        this.gemfireProperties = gemfireProperties;
    }

    public void addGemfireProperties(Properties gemfireProperties) {
        this.gemfireProperties.putAll((Map<?, ?>)gemfireProperties);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void addJarNames(Set<String> jarNames) {
        this.jarNames.addAll(jarNames);
    }

    public void addJarNames(String[] jarNames) {
        if (jarNames == null) {
            return;
        }
        this.jarNames.addAll(Stream.of(jarNames).collect(Collectors.toSet()));
    }

    public void removeJarNames(String[] jarNames) {
        if (jarNames != null) {
            this.jarNames.removeAll(Stream.of(jarNames).collect(Collectors.toSet()));
        } else {
            this.jarNames.clear();
        }
    }

    public Set<String> getJarNames() {
        return this.jarNames;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.configName, out);
        DataSerializer.writeString(this.cacheXmlFileName, out);
        DataSerializer.writeString(this.cacheXmlContent, out);
        DataSerializer.writeString(this.propertiesFileName, out);
        DataSerializer.writeProperties(this.gemfireProperties, out);
        DataSerializer.writeHashSet((HashSet)this.jarNames, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.configName = DataSerializer.readString(in);
        this.cacheXmlFileName = DataSerializer.readString(in);
        this.cacheXmlContent = DataSerializer.readString(in);
        this.propertiesFileName = DataSerializer.readString(in);
        this.gemfireProperties = DataSerializer.readProperties(in);
        this.jarNames = DataSerializer.readHashSet(in);
    }

    public String toString() {
        return "Configuration [configName=" + this.configName + ", cacheXmlContent=" + this.cacheXmlContent + ", cacheXmlFileName=" + this.cacheXmlFileName + ", propertiesFileName=" + this.propertiesFileName + ", gemfireProperties=" + this.gemfireProperties + ", jarNames=" + this.jarNames + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheXmlContent == null ? 0 : this.cacheXmlContent.hashCode());
        result = 31 * result + (this.cacheXmlFileName == null ? 0 : this.cacheXmlFileName.hashCode());
        result = 31 * result + (this.configName == null ? 0 : this.configName.hashCode());
        result = 31 * result + (this.gemfireProperties == null ? 0 : this.gemfireProperties.hashCode());
        result = 31 * result + (this.jarNames == null ? 0 : this.jarNames.hashCode());
        result = 31 * result + (this.propertiesFileName == null ? 0 : this.propertiesFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (this.cacheXmlContent == null ? other.cacheXmlContent != null : !this.cacheXmlContent.equals(other.cacheXmlContent)) {
            return false;
        }
        if (this.cacheXmlFileName == null ? other.cacheXmlFileName != null : !this.cacheXmlFileName.equals(other.cacheXmlFileName)) {
            return false;
        }
        if (this.configName == null ? other.configName != null : !this.configName.equals(other.configName)) {
            return false;
        }
        if (this.gemfireProperties == null ? other.gemfireProperties != null : !this.gemfireProperties.equals(other.gemfireProperties)) {
            return false;
        }
        if (this.jarNames == null ? other.jarNames != null : !this.jarNames.equals(other.jarNames)) {
            return false;
        }
        return !(this.propertiesFileName == null ? other.propertiesFileName != null : !this.propertiesFileName.equals(other.propertiesFileName));
    }
}

