/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class UploadJarFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        ClusterConfigurationService sharedConfig;
        InternalLocator locator = (InternalLocator)Locator.getLocator();
        Object[] args = (Object[])context.getArguments();
        String group = (String)args[0];
        String jarName = (String)args[1];
        if (locator != null && group != null && jarName != null && (sharedConfig = locator.getSharedConfiguration()) != null) {
            try {
                byte[] jarBytes = sharedConfig.getJarBytesFromThisLocator(group, jarName);
                context.getResultSender().lastResult(jarBytes);
            }
            catch (Exception e) {
                logger.error((Object)e);
                context.getResultSender().sendException(e);
            }
        }
        context.getResultSender().lastResult(null);
    }

    @Override
    public String getId() {
        return UploadJarFunction.class.getName();
    }
}

