/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.RegionService;
import org.apache.geode.pdx.FieldType;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.PdxWriter;
import org.apache.geode.pdx.internal.AutoSerializableManager;

public class ReflectionBasedAutoSerializer
implements PdxSerializer,
Declarable {
    private final AutoSerializableManager manager;

    public ReflectionBasedAutoSerializer() {
        this(new String[0]);
    }

    public ReflectionBasedAutoSerializer(List<String> classes) {
        this(ReflectionBasedAutoSerializer.listToArray(classes));
    }

    private static String[] listToArray(List<String> l) {
        if (l == null) {
            l = Collections.emptyList();
        }
        return l.toArray(new String[l.size()]);
    }

    public ReflectionBasedAutoSerializer(String ... patterns) {
        this(false, patterns);
    }

    public ReflectionBasedAutoSerializer(boolean checkPortability, String ... patterns) {
        this.manager = AutoSerializableManager.create(this, checkPortability, patterns);
    }

    public void setSerializableClasses(List<String> patterns) {
        this.reconfigure(ReflectionBasedAutoSerializer.listToArray(patterns));
    }

    public void reconfigure(String ... patterns) {
        this.reconfigure(false, patterns);
    }

    public void reconfigure(boolean checkPortability, String ... patterns) {
        this.manager.reconfigure(checkPortability, patterns);
    }

    @Override
    public boolean toData(Object obj, PdxWriter writer) {
        return this.manager.writeData(writer, obj);
    }

    @Override
    public Object fromData(Class<?> clazz, PdxReader reader) {
        return this.manager.readData(reader, clazz);
    }

    @Override
    public void init(Properties props) {
        this.manager.init(props);
    }

    public Properties getConfig() {
        return this.manager.getConfig();
    }

    public boolean isClassAutoSerialized(Class<?> clazz) {
        return this.manager.defaultIsClassAutoSerialized(clazz);
    }

    public boolean isFieldIncluded(Field f, Class<?> clazz) {
        return this.manager.defaultIsFieldIncluded(f, clazz);
    }

    public String getFieldName(Field f, Class<?> clazz) {
        return f.getName();
    }

    public boolean isIdentityField(Field f, Class<?> clazz) {
        return this.manager.defaultIsIdentityField(f, clazz);
    }

    public FieldType getFieldType(Field f, Class<?> clazz) {
        return this.manager.defaultGetFieldType(f, clazz);
    }

    public boolean transformFieldValue(Field f, Class<?> clazz) {
        return false;
    }

    public Object writeTransform(Field f, Class<?> clazz, Object originalValue) {
        return originalValue;
    }

    public Object readTransform(Field f, Class<?> clazz, Object serializedValue) {
        return serializedValue;
    }

    public RegionService getRegionService() {
        return this.manager.getRegionService();
    }

    public Object getManager() {
        return this.manager;
    }
}

