/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.cache.util.CacheWriterAdapter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.geode.pdx.PdxInitializationException;
import org.apache.geode.pdx.PdxRegistryMismatchException;
import org.apache.geode.pdx.internal.CheckTypeRegistryState;
import org.apache.geode.pdx.internal.EnumId;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistration;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class PeerTypeRegistration
implements TypeRegistration {
    private static final Logger logger = LogService.getLogger();
    private static final int MAX_TRANSACTION_FAILURES = 10;
    public static final String LOCK_SERVICE_NAME = "__PDX";
    public static final String REGION_NAME = "PdxTypes";
    public static final String REGION_FULL_PATH = "/PdxTypes";
    public static final int PLACE_HOLDER_FOR_TYPE_ID = 0xFFFFFF;
    public static final int PLACE_HOLDER_FOR_DS_ID = -16777216;
    private int dsId;
    private final int maxTypeId;
    private volatile DistributedLockService dls;
    private final Object dlsLock = new Object();
    private InternalCache cache;
    private Region<Object, Object> idToType;
    private Map<PdxType, Integer> typeToId = Collections.synchronizedMap(new HashMap());
    private Map<EnumInfo, EnumId> enumToId = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<PdxType>> classToType = new CopyOnWriteHashMap<String, Set<PdxType>>();
    private volatile boolean typeRegistryInUse = false;
    private static final String LOCK_NAME = "PDX_LOCK";
    private int lastAllocatedTypeId;
    private int lastAllocatedEnumId;

    public PeerTypeRegistration(InternalCache cache) {
        this.cache = cache;
        int distributedSystemId = cache.getInternalDistributedSystem().getDistributionManager().getDistributedSystemId();
        if (distributedSystemId == -1) {
            distributedSystemId = 0;
        }
        this.dsId = distributedSystemId << 24;
        this.maxTypeId = 0xFFFFFF;
    }

    private Region<Object, Object> getIdToType() {
        if (this.idToType != null) {
            return this.idToType;
        }
        if (this.cache.getPdxPersistent() && this.cache.getCacheConfig().pdxDiskStoreUserSet) {
            throw new PdxInitializationException("PDX registry could not be initialized because the disk store " + this.cache.getPdxDiskStore() + " was not created.");
        }
        throw new PdxInitializationException("PDX registry was not initialized.");
    }

    @Override
    public void initialize() {
        AttributesFactory<Object, Object> factory = new AttributesFactory<Object, Object>();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        if (this.cache.getPdxPersistent()) {
            if (this.cache.getCacheConfig().pdxDiskStoreUserSet) {
                factory.setDiskStoreName(this.cache.getPdxDiskStore());
            } else {
                factory.setDiskStoreName(this.cache.getOrCreateDefaultDiskStore().getName());
            }
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        } else {
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        factory.addCacheListener(new CacheListenerAdapter<Object, Object>(){

            @Override
            public void afterCreate(EntryEvent<Object, Object> event) {
                PeerTypeRegistration.this.verifyConfiguration();
                Object value = event.getNewValue();
                if (value instanceof PdxType) {
                    PeerTypeRegistration.this.updateClassToTypeMap((PdxType)value);
                }
            }
        });
        factory.setCacheWriter(new CacheWriterAdapter<Object, Object>(){

            @Override
            public void beforeCreate(EntryEvent<Object, Object> event) throws CacheWriterException {
                Object newValue = event.getNewValue();
                if (newValue instanceof PdxType) {
                    logger.info("Adding new type: {}", (Object)((PdxType)event.getNewValue()).toFormattedString());
                } else {
                    logger.info("Adding new type: {} {}", event.getKey(), (Object)((EnumInfo)newValue).toFormattedString());
                }
            }

            @Override
            public void beforeUpdate(EntryEvent<Object, Object> event) throws CacheWriterException {
                if (!event.getRegion().get(event.getKey()).equals(event.getNewValue())) {
                    PdxRegistryMismatchException ex = new PdxRegistryMismatchException("Trying to add a PDXType with the same id as an existing PDX type. id=" + event.getKey() + ", existing pdx type " + event.getOldValue() + ", new type " + event.getNewValue());
                    throw new CacheWriterException(ex);
                }
            }
        });
        RegionAttributes regionAttrs = factory.create();
        InternalRegionArguments internalArgs = new InternalRegionArguments();
        internalArgs.setIsUsedForMetaRegion(true);
        internalArgs.setMetaRegionWithTransactions(true);
        try {
            this.idToType = this.cache.createVMRegion(REGION_NAME, regionAttrs, internalArgs);
        }
        catch (IOException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        catch (TimeoutException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        catch (RegionExistsException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new PdxInitializationException("Could not create pdx registry", ex);
        }
        if (!this.getIdToType().isEmpty()) {
            this.verifyConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributedLockService getLockService() {
        if (this.dls != null) {
            return this.dls;
        }
        Object object = this.dlsLock;
        synchronized (object) {
            block7: {
                if (this.dls == null) {
                    try {
                        this.dls = DLockService.create(LOCK_SERVICE_NAME, this.cache.getInternalDistributedSystem(), true, true, true);
                    }
                    catch (IllegalArgumentException e) {
                        this.dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
                        if (this.dls != null) break block7;
                        throw e;
                    }
                }
            }
            return this.dls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateTypeId(PdxType newType) {
        TXStateProxy currentState = this.suspendTX();
        Region<Object, Object> r = this.getIdToType();
        int id = newType.hashCode() & 0xFFFFFF;
        int newTypeId = id | this.dsId;
        try {
            int maxTry = this.maxTypeId;
            while (r.get(newTypeId) != null) {
                if (--maxTry == 0) {
                    throw new InternalGemFireError("Used up all of the PDX type ids for this distributed system. The maximum number of PDX types is " + this.maxTypeId);
                }
                if (++id > this.maxTypeId) {
                    id = 1;
                }
                newTypeId = id | this.dsId;
            }
            int n = newTypeId;
            return n;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumId allocateEnumId(EnumInfo ei) {
        TXStateProxy currentState = this.suspendTX();
        Region<Object, Object> r = this.getIdToType();
        int id = ei.hashCode() & 0xFFFFFF;
        int newEnumId = id | this.dsId;
        try {
            int maxTry = this.maxTypeId;
            while (r.get(new EnumId(newEnumId)) != null) {
                if (--maxTry == 0) {
                    throw new InternalGemFireError("Used up all of the PDX type ids for this distributed system. The maximum number of PDX types is " + this.maxTypeId);
                }
                if (++id > this.maxTypeId) {
                    id = 1;
                }
                newEnumId = id | this.dsId;
            }
            EnumId enumId = new EnumId(newEnumId);
            return enumId;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    private void unlock() {
        try {
            DistributedLockService dls = this.getLockService();
            dls.unlock(LOCK_NAME);
        }
        catch (LockServiceDestroyedException e) {
            this.cache.getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
    }

    private void lock() {
        DistributedLockService dls = this.getLockService();
        try {
            if (!dls.lock(LOCK_NAME, -1L, -1L)) {
                throw new InternalGemFireException("Could not obtain pdx lock");
            }
        }
        catch (LockServiceDestroyedException e) {
            this.cache.getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
    }

    private boolean useUDPMessagingIfNecessary() {
        boolean result = false;
        InternalDistributedSystem sys = this.cache.getInternalDistributedSystem();
        if (sys != null && !sys.threadOwnsResources()) {
            sys.getDistributionManager().forceUDPMessagingForCurrentThread();
            result = true;
        }
        return result;
    }

    private void releaseUDPMessaging(boolean release) {
        InternalDistributedSystem sys;
        if (release && (sys = this.cache.getInternalDistributedSystem()) != null) {
            sys.getDistributionManager().releaseUDPMessagingForCurrentThread();
        }
    }

    @Override
    public int getLastAllocatedTypeId() {
        this.verifyConfiguration();
        return this.lastAllocatedTypeId;
    }

    public int getLastAllocatedEnumId() {
        this.verifyConfiguration();
        return this.lastAllocatedEnumId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int defineType(PdxType newType) {
        this.verifyConfiguration();
        Integer existingId = this.typeToId.get(newType);
        if (existingId != null) {
            return existingId;
        }
        this.lock();
        try {
            int id = this.getExistingIdForType(newType);
            if (id != -1) {
                int n = id;
                return n;
            }
            id = this.allocateTypeId(newType);
            newType.setTypeId(id);
            this.updateIdToTypeRegion(newType);
            this.typeToId.put(newType, id);
            int n = newType.getTypeId();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    private void updateIdToTypeRegion(PdxType newType) {
        this.updateRegion(newType.getTypeId(), newType);
    }

    private void updateIdToEnumRegion(EnumId id, EnumInfo ei) {
        this.updateRegion(id, ei);
    }

    private void updateRegion(Object k, Object v) {
        Region<Object, Object> r = this.getIdToType();
        InternalCache cache = (InternalCache)r.getRegionService();
        this.checkDistributedTypeRegistryState();
        TXManagerImpl txManager = (TXManagerImpl)cache.getCacheTransactionManager();
        TXStateProxy currentState = this.suspendTX();
        boolean state = this.useUDPMessagingIfNecessary();
        try {
            int failureCount = 0;
            while (true) {
                txManager.begin();
                try {
                    r.put(k, v);
                    txManager.commit();
                    return;
                }
                catch (TransactionException e) {
                    if (!txManager.exists()) continue;
                    txManager.rollback();
                    if (++failureCount <= 10) continue;
                    throw e;
                }
                break;
            }
        }
        finally {
            this.releaseUDPMessaging(state);
            this.resumeTX(currentState);
        }
    }

    private void checkDistributedTypeRegistryState() {
        CheckTypeRegistryState.send(this.cache.getDistributionManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PdxType getType(int typeId) {
        this.verifyConfiguration();
        TXStateProxy currentState = this.suspendTX();
        try {
            PdxType pdxType = (PdxType)this.getIdToType().get(typeId);
            return pdxType;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteType(int typeId, PdxType type) {
        block6: {
            this.verifyConfiguration();
            TXStateProxy currentState = this.suspendTX();
            Region<Object, Object> r = this.getIdToType();
            try {
                if (r.containsKey(typeId)) break block6;
                this.lock();
                try {
                    r.put(typeId, type);
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                this.resumeTX(currentState);
            }
        }
    }

    @Override
    public void gatewaySenderStarted(GatewaySender gatewaySender) {
        if (!this.typeRegistryInUse || this.idToType == null) {
            return;
        }
        this.checkAllowed(true, this.hasPersistentRegions());
    }

    @Override
    public void creatingPersistentRegion() {
        if (!this.typeRegistryInUse) {
            return;
        }
        this.checkAllowed(this.hasGatewaySender(), true);
    }

    public boolean hasGatewaySender() {
        Set<GatewaySender> sendersAndAsyncQueues = this.cache.getGatewaySenders();
        Iterator<GatewaySender> itr = sendersAndAsyncQueues.iterator();
        while (itr.hasNext()) {
            GatewaySender sender = itr.next();
            if (!AsyncEventQueueImpl.isAsyncEventQueue(sender.getId())) continue;
            itr.remove();
        }
        return !sendersAndAsyncQueues.isEmpty();
    }

    @Override
    public void creatingPool() {
        if (this.typeRegistryInUse) {
            throw new PdxInitializationException("The PDX metadata has already been created as a peer metadata region. Please create your pools first");
        }
    }

    void verifyConfiguration() {
        if (this.typeRegistryInUse) {
            return;
        }
        boolean hasPersistentRegions = this.hasPersistentRegions();
        this.checkAllowed(this.hasGatewaySender(), hasPersistentRegions);
        for (Pool pool : PoolManager.getAll().values()) {
            if (((PoolImpl)pool).isUsedByGateway()) continue;
            throw new PdxInitializationException("The PDX metadata has already been created as a peer metadata region. Please use ClientCacheFactory to create clients.");
        }
        this.typeRegistryInUse = true;
    }

    public boolean hasPersistentRegions() {
        Collection<DiskStore> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
        boolean hasPersistentRegions = false;
        for (DiskStore store : diskStores) {
            hasPersistentRegions |= ((DiskStoreImpl)store).hasPersistedData();
        }
        return hasPersistentRegions;
    }

    private void checkAllowed(boolean hasGatewaySender, boolean hasDiskStore) {
        if (hasDiskStore && !this.cache.getPdxPersistent()) {
            throw new PdxInitializationException("The PDX metadata must be persistent in a member that has persistent data. See CacheFactory.setPdxPersistent.");
        }
        int distributedSystemId = this.cache.getInternalDistributedSystem().getDistributionManager().getDistributedSystemId();
        if (hasGatewaySender && distributedSystemId == -1) {
            throw new PdxInitializationException("When using PDX with a WAN gateway sender, you must set the distributed-system-id gemfire property for your distributed system. See the javadocs for DistributedSystem.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getExistingIdForType(PdxType newType) {
        int totalPdxTypeIdInDS = 0;
        TXStateProxy currentState = this.suspendTX();
        try {
            int result = -1;
            for (Map.Entry<Object, Object> entry : this.getIdToType().entrySet()) {
                Object v = entry.getValue();
                Object k = entry.getKey();
                if (k instanceof EnumId) {
                    EnumId id = (EnumId)k;
                    EnumInfo info = (EnumInfo)v;
                    this.enumToId.put(info, id);
                    continue;
                }
                PdxType foundType = (PdxType)v;
                Integer id = (Integer)k;
                int tmpDsId = 0xFF000000 & id;
                if (tmpDsId == this.dsId) {
                    ++totalPdxTypeIdInDS;
                }
                this.typeToId.put(foundType, id);
                if (!foundType.equals(newType)) continue;
                result = foundType.getTypeId();
            }
            if (totalPdxTypeIdInDS == this.maxTypeId) {
                throw new InternalGemFireError("Used up all of the PDX type ids for this distributed system. The maximum number of PDX types is " + this.maxTypeId);
            }
            int n = result;
            return n;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumId getExistingIdForEnum(EnumInfo ei) {
        TXStateProxy currentState = this.suspendTX();
        int totalEnumIdInDS = 0;
        try {
            EnumId result = null;
            for (Map.Entry<Object, Object> entry : this.getIdToType().entrySet()) {
                Object v = entry.getValue();
                Object k = entry.getKey();
                if (k instanceof EnumId) {
                    EnumId id = (EnumId)k;
                    EnumInfo info = (EnumInfo)v;
                    this.enumToId.put(info, id);
                    int tmpDsId = 0xFF000000 & id.intValue();
                    if (tmpDsId == this.dsId) {
                        ++totalEnumIdInDS;
                    }
                    if (!ei.equals(info)) continue;
                    result = id;
                    continue;
                }
                this.typeToId.put((PdxType)v, (Integer)k);
            }
            if (totalEnumIdInDS == this.maxTypeId) {
                throw new InternalGemFireError("Used up all of the PDX enum ids for this distributed system. The maximum number of PDX types is " + this.maxTypeId);
            }
            Iterator<Map.Entry<Object, Object>> iterator = result;
            return iterator;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    private TXStateProxy suspendTX() {
        InternalCache cache = (InternalCache)this.getIdToType().getRegionService();
        TXManagerImpl txManager = (TXManagerImpl)cache.getCacheTransactionManager();
        return txManager.internalSuspend();
    }

    private void resumeTX(TXStateProxy state) {
        if (state != null) {
            TXManagerImpl txManager = state.getTxMgr();
            txManager.internalResume(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEnumId(Enum<?> v) {
        this.verifyConfiguration();
        EnumInfo ei = new EnumInfo(v);
        EnumId existingId = this.enumToId.get(ei);
        if (existingId != null) {
            return existingId.intValue();
        }
        this.lock();
        try {
            EnumId id = this.getExistingIdForEnum(ei);
            if (id != null) {
                int n = id.intValue();
                return n;
            }
            id = this.allocateEnumId(ei);
            this.updateIdToEnumRegion(id, ei);
            this.enumToId.put(ei, id);
            int n = id.intValue();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteEnum(int id, EnumInfo enumInfo) {
        block6: {
            this.verifyConfiguration();
            TXStateProxy currentState = this.suspendTX();
            EnumId enumId = new EnumId(id);
            Region<Object, Object> r = this.getIdToType();
            try {
                if (r.containsKey(enumId)) break block6;
                this.lock();
                try {
                    r.put(enumId, enumInfo);
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                this.resumeTX(currentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int defineEnum(EnumInfo newInfo) {
        this.verifyConfiguration();
        EnumId existingId = this.enumToId.get(newInfo);
        if (existingId != null) {
            return existingId.intValue();
        }
        this.lock();
        try {
            EnumId id = this.getExistingIdForEnum(newInfo);
            if (id != null) {
                int n = id.intValue();
                return n;
            }
            id = this.allocateEnumId(newInfo);
            this.updateIdToEnumRegion(id, newInfo);
            this.enumToId.put(newInfo, id);
            int n = id.intValue();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumInfo getEnumById(int id) {
        this.verifyConfiguration();
        EnumId enumId = new EnumId(id);
        TXStateProxy currentState = this.suspendTX();
        try {
            EnumInfo enumInfo = (EnumInfo)this.getIdToType().get(enumId);
            return enumInfo;
        }
        finally {
            this.resumeTX(currentState);
        }
    }

    @Override
    public Map<Integer, PdxType> types() {
        HashMap<Integer, PdxType> types = new HashMap<Integer, PdxType>();
        for (Map.Entry<Object, Object> type : this.getIdToType().entrySet()) {
            Object id = type.getKey();
            if (!(type.getValue() instanceof PdxType)) continue;
            types.put((Integer)id, (PdxType)type.getValue());
        }
        return types;
    }

    @Override
    public Map<Integer, EnumInfo> enums() {
        HashMap<Integer, EnumInfo> enums = new HashMap<Integer, EnumInfo>();
        for (Map.Entry<Object, Object> type : this.getIdToType().entrySet()) {
            Object id = type.getKey();
            if (!(type.getValue() instanceof EnumInfo)) continue;
            enums.put(((EnumId)id).intValue(), (EnumInfo)type.getValue());
        }
        return enums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassToTypeMap(PdxType type) {
        if (type != null) {
            Map<String, Set<PdxType>> map = this.classToType;
            synchronized (map) {
                if (type.getClassName().equals("__GEMFIRE_JSON")) {
                    return;
                }
                Set<PdxType> pdxTypeSet = this.classToType.get(type.getClassName());
                if (pdxTypeSet == null) {
                    pdxTypeSet = new CopyOnWriteHashSet<PdxType>();
                }
                pdxTypeSet.add(type);
                this.classToType.put(type.getClassName(), pdxTypeSet);
            }
        }
    }

    @Override
    public PdxType getPdxTypeForField(String fieldName, String className) {
        Set<PdxType> pdxTypes = this.classToType.get(className);
        if (pdxTypes != null) {
            for (PdxType pdxType : pdxTypes) {
                if (pdxType.getPdxField(fieldName) == null) continue;
                return pdxType;
            }
        }
        return null;
    }

    public Map<String, Set<PdxType>> getClassToType() {
        return this.classToType;
    }

    @Override
    public void testClearRegistry() {
        this.idToType.clear();
        this.enumToId.clear();
        this.typeToId.clear();
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void addImportedType(int typeId, PdxType importedType) {
        this.addRemoteType(typeId, importedType);
    }

    @Override
    public void addImportedEnum(int id, EnumInfo importedInfo) {
        this.addRemoteEnum(id, importedInfo);
    }

    public static int getPdxRegistrySize() {
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
        if (cache == null) {
            return 0;
        }
        TypeRegistry registry = cache.getPdxRegistry();
        if (registry == null) {
            return 0;
        }
        return registry.getLocalSize();
    }

    @Override
    public int getLocalSize() {
        return this.idToType.size();
    }
}

