/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZRankExecutor
extends SortedSetExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int rank;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        ByteArrayWrapper member = new ByteArrayWrapper(commandElems.get(2));
        DoubleWrapper value = keyRegion.get(member);
        if (value == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        try {
            rank = this.getRange(context, key, member, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), rank));
    }

    private int getRange(ExecutionHandlerContext context, ByteArrayWrapper key, ByteArrayWrapper member, DoubleWrapper valueWrapper) throws Exception {
        Query query = this.isReverse() ? this.getQuery(key, SortedSetQuery.ZREVRANK, context) : this.getQuery(key, SortedSetQuery.ZRANK, context);
        Object[] params = new Object[]{valueWrapper.score, valueWrapper.score, member};
        SelectResults results = (SelectResults)query.execute(params);
        return (Integer)results.asList().get(0);
    }

    protected boolean isReverse() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the ZRANK command is \"ZRANK key member\"";
    }
}

