/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractMultiPartCommandsController;
import org.apache.geode.management.internal.web.util.ConvertUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller(value="configController")
@RequestMapping(value={"/v1"})
public class ConfigCommandsController
extends AbstractMultiPartCommandsController {
    @RequestMapping(method={RequestMethod.POST}, value={"/config"})
    @ResponseBody
    public String alterRuntime(@RequestParam(value="group", required=false) String group, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="archive-disk-space-limit", required=false) Integer archiveDiskSpaceLimit, @RequestParam(value="archive-file-size-limit", required=false) Integer archiveFileSizeLimit, @RequestParam(value="log-disk-space-limit", required=false) Integer logDiskSpaceLimit, @RequestParam(value="log-file-size-limit", required=false) Integer logFileSizeLimit, @RequestParam(value="log-level", required=false) String logLevel, @RequestParam(value="statistic-archive-file", required=false) String statisticsArchiveFile, @RequestParam(value="statistic-sample-rate", required=false) Integer statisticsSampleRate, @RequestParam(value="enable-statistics", required=false) Boolean enableStatistics, @RequestParam(value="copy-on-read", required=false) Boolean copyOnRead, @RequestParam(value="lock-lease", required=false) Integer lockLease, @RequestParam(value="lock-timeout", required=false) Integer lockTimeout, @RequestParam(value="message-sync-interval", required=false) Integer messageSyncInterval, @RequestParam(value="search-timeout", required=false) Integer searchTimeout) {
        CommandStringBuilder command = new CommandStringBuilder("alter runtime");
        if (ConfigCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (ConfigCommandsController.hasValue(group)) {
            command.addOption("group", group);
        }
        if (ConfigCommandsController.hasValue(archiveDiskSpaceLimit)) {
            command.addOption("archive-disk-space-limit", Integer.toString(archiveDiskSpaceLimit));
        }
        if (ConfigCommandsController.hasValue(archiveFileSizeLimit)) {
            command.addOption("archive-file-size-limit", Integer.toString(archiveFileSizeLimit));
        }
        if (ConfigCommandsController.hasValue(logDiskSpaceLimit)) {
            command.addOption("log-disk-space-limit", Integer.toString(logDiskSpaceLimit));
        }
        if (ConfigCommandsController.hasValue(logFileSizeLimit)) {
            command.addOption("log-file-size-limit", Integer.toString(logFileSizeLimit));
        }
        if (ConfigCommandsController.hasValue(logLevel)) {
            command.addOption("log-level", logLevel);
        }
        if (ConfigCommandsController.hasValue(statisticsArchiveFile)) {
            command.addOption("statistic-archive-file", statisticsArchiveFile);
        }
        if (ConfigCommandsController.hasValue(statisticsSampleRate)) {
            command.addOption("statistic-sample-rate", Integer.toString(statisticsSampleRate));
        }
        if (ConfigCommandsController.hasValue(enableStatistics)) {
            command.addOption("enable-statistics", Boolean.toString(enableStatistics));
        }
        if (ConfigCommandsController.hasValue(copyOnRead)) {
            command.addOption("copy-on-read", Boolean.toString(copyOnRead));
        }
        if (ConfigCommandsController.hasValue(lockLease)) {
            command.addOption("lock-lease", Integer.toString(lockLease));
        }
        if (ConfigCommandsController.hasValue(lockTimeout)) {
            command.addOption("lock-timeout", Integer.toString(lockTimeout));
        }
        if (ConfigCommandsController.hasValue(messageSyncInterval)) {
            command.addOption("message-sync-interval", Integer.toString(messageSyncInterval));
        }
        if (ConfigCommandsController.hasValue(searchTimeout)) {
            command.addOption("search-timeout", Integer.toString(searchTimeout));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/members/{member}/config"})
    @ResponseBody
    public String describeConfig(@PathVariable(value="member") String memberNameId, @RequestParam(value="hide-defaults", defaultValue="true") Boolean hideDefaults) {
        CommandStringBuilder command = new CommandStringBuilder("describe config");
        command.addOption("member", ConfigCommandsController.decode(memberNameId));
        command.addOption("hide-defaults", String.valueOf(hideDefaults));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/config"})
    public Callable<ResponseEntity<String>> exportConfig(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members, @RequestParam(value="dir", required=false) String directory) {
        CommandStringBuilder command = new CommandStringBuilder("export config");
        if (ConfigCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (ConfigCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        if (ConfigCommandsController.hasValue(directory)) {
            command.addOption("dir", ConfigCommandsController.decode(directory));
        }
        return this.getProcessCommandCallable(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/config/cluster"})
    public Callable<ResponseEntity<String>> exportClusterConfig(@RequestParam(value="zip-file-name") String zipFile) {
        CommandStringBuilder command = new CommandStringBuilder("export cluster-configuration");
        command.addOption("zip-file-name", zipFile);
        return this.getProcessCommandCallable(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/config/cluster"})
    public Callable<ResponseEntity<String>> importClusterConfig(@RequestParam(value="resources") MultipartFile[] zipFileResources, @RequestParam(value="zip-file-name") String zipFileName) throws IOException {
        CommandStringBuilder command = new CommandStringBuilder("import cluster-configuration");
        command.addOption("zip-file-name", zipFileName);
        return this.getProcessCommandCallable(command.toString(), this.getEnvironment(), ConvertUtils.convert(zipFileResources));
    }
}

