/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="durableClientController")
@RequestMapping(value={"/v1"})
public class DurableClientCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/durable-clients/{durable-client-id}/cqs"})
    @ResponseBody
    public String listDurableClientContinuousQueries(@PathVariable(value="durable-client-id") String durableClientId, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="group", required=false) String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("list durable-cqs");
        command.addOption("durable-client-id", DurableClientCommandsController.decode(durableClientId));
        if (DurableClientCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (DurableClientCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/durable-clients/{durable-client-id}/cqs/events"})
    @ResponseBody
    public String countDurableClientContinuousQueryEvents(@PathVariable(value="durable-client-id") String durableClientId, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="group", required=false) String[] groups) {
        return this.internalCountDurableClientContinuousQueryEvents(DurableClientCommandsController.decode(durableClientId), null, memberNameId, groups);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/durable-clients/{durable-client-id}/cqs/{durable-cq-name}/events"})
    @ResponseBody
    public String countDurableClientContinuousQueryEvents(@PathVariable(value="durable-client-id") String durableClientId, @PathVariable(value="durable-cq-name") String durableCqName, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="group", required=false) String[] groups) {
        return this.internalCountDurableClientContinuousQueryEvents(DurableClientCommandsController.decode(durableClientId), DurableClientCommandsController.decode(durableCqName), memberNameId, groups);
    }

    protected String internalCountDurableClientContinuousQueryEvents(String durableClientId, String cqName, String memberNameId, String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("show subscription-queue-size");
        command.addOption("durable-client-id", durableClientId);
        if (DurableClientCommandsController.hasValue(cqName)) {
            command.addOption("durable-cq-name", cqName);
        }
        if (DurableClientCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (DurableClientCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/durable-clients/{durable-client-id}"}, params={"op=close"})
    @ResponseBody
    public String closeDurableClient(@PathVariable(value="durable-client-id") String durableClientId, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="group", required=false) String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("close durable-client");
        command.addOption("durable-client-id", DurableClientCommandsController.decode(durableClientId));
        if (DurableClientCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (DurableClientCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/durable-clients/{durable-client-id}/cqs/{durable-cq-name}"}, params={"op=close"})
    @ResponseBody
    public String closeDurableContinuousQuery(@PathVariable(value="durable-client-id") String durableClientId, @PathVariable(value="durable-cq-name") String durableCqName, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="group", required=false) String[] groups) {
        CommandStringBuilder command = new CommandStringBuilder("close durable-cq");
        command.addOption("durable-client-id", DurableClientCommandsController.decode(durableClientId));
        command.addOption("durable-cq-name", DurableClientCommandsController.decode(durableCqName));
        if (DurableClientCommandsController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (DurableClientCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        return this.processCommand(command.toString());
    }
}

