/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="exportLogController")
@RequestMapping(value={"/v1"})
public class ExportLogController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/logs"})
    public ResponseEntity<InputStreamResource> exportLogs(@RequestParam(value="dir", required=false) String directory, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String memberNameId, @RequestParam(value="log-level", required=false) String logLevel, @RequestParam(value="only-log-level", defaultValue="false") Boolean onlyLogLevel, @RequestParam(value="merge-log", defaultValue="false") Boolean mergeLog, @RequestParam(value="start-time", required=false) String startTime, @RequestParam(value="end-time", required=false) String endTime, @RequestParam(value="logs-only", required=false) boolean logsOnly, @RequestParam(value="stats-only", required=false) boolean statsOnly, @RequestParam(value="file-size-limit", required=false) String fileSizeLimit) {
        CommandStringBuilder command = new CommandStringBuilder("export logs");
        command.addOption("dir", ExportLogController.decode(directory));
        if (ExportLogController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (ExportLogController.hasValue(memberNameId)) {
            command.addOption("member", memberNameId);
        }
        if (ExportLogController.hasValue(logLevel)) {
            command.addOption("log-level", logLevel);
        }
        command.addOption("only-log-level", String.valueOf(onlyLogLevel));
        command.addOption("merge-log", String.valueOf(mergeLog));
        command.addOption("logs-only", String.valueOf(logsOnly));
        command.addOption("stats-only", String.valueOf(statsOnly));
        command.addOption("file-size-limit", fileSizeLimit);
        if (ExportLogController.hasValue(startTime)) {
            command.addOption("start-time", startTime);
        }
        if (ExportLogController.hasValue(endTime)) {
            command.addOption("end-time", endTime);
        }
        String result = this.processCommand(command.toString());
        return this.getResponse(result);
    }

    ResponseEntity<InputStreamResource> getResponse(String result) {
        Result commandResult = ResultBuilder.fromJson((String)result);
        if (commandResult.getStatus().equals((Object)Result.Status.OK)) {
            return this.getOKResponse(commandResult);
        }
        return this.getErrorResponse(result);
    }

    private ResponseEntity<InputStreamResource> getErrorResponse(String result) {
        HttpHeaders respHeaders = new HttpHeaders();
        try {
            InputStreamResource isr = new InputStreamResource(IOUtils.toInputStream((String)result, (String)"UTF-8"));
            respHeaders.set("Content-Type", "application/json");
            return new ResponseEntity((Object)isr, (MultiValueMap)respHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException("IO Error writing file to output stream", e);
        }
    }

    private ResponseEntity<InputStreamResource> getOKResponse(Result commandResult) {
        HttpHeaders respHeaders = new HttpHeaders();
        String filePath = commandResult.nextLine().trim();
        File zipFile = new File(filePath);
        try {
            InputStreamResource isr = new InputStreamResource((InputStream)new FileInputStream(zipFile));
            respHeaders.set("Content-Type", "application/octet-stream");
            ResponseEntity responseEntity = new ResponseEntity((Object)isr, (MultiValueMap)respHeaders, HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            throw new RuntimeException("IO Error writing file to output stream", e);
        }
        finally {
            FileUtils.deleteQuietly((File)zipFile);
        }
    }
}

