/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="queueController")
@RequestMapping(value={"/v1"})
public class QueueCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.POST}, value={"/async-event-queues"})
    @ResponseBody
    public String createAsyncEventQueue(@RequestParam(value="id") String asyncEventQueueId, @RequestParam(value="listener") String listener, @RequestParam(value="listener-param", required=false) String[] listenerParametersValues, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="parallel", defaultValue="false") Boolean parallel, @RequestParam(value="enable-batch-conflation", defaultValue="false") Boolean enableBatchConflation, @RequestParam(value="batch-size", defaultValue="100") Integer batchSize, @RequestParam(value="batch-time-interval", defaultValue="1000") Integer batchTimeInterval, @RequestParam(value="persistent", defaultValue="false") Boolean persistent, @RequestParam(value="disk-store", required=false) String diskStore, @RequestParam(value="disk-synchronous", defaultValue="true") Boolean diskSynchronous, @RequestParam(value="forward-expiration-destroy", defaultValue="false") Boolean forwardExpirationDestroy, @RequestParam(value="max-queue-memory", defaultValue="100") Integer maxQueueMemory, @RequestParam(value="dispatcher-threads", defaultValue="1") Integer dispatcherThreads, @RequestParam(value="order-policy", defaultValue="KEY") String orderPolicy, @RequestParam(value="gateway-event-filter", required=false) String[] gatewayEventFilters, @RequestParam(value="gateway-event-substitution-filter", required=false) String gatewaySubstitutionFilter) {
        CommandStringBuilder command = new CommandStringBuilder("create async-event-queue");
        command.addOption("id", asyncEventQueueId);
        command.addOption("listener", listener);
        if (QueueCommandsController.hasValue(listenerParametersValues)) {
            command.addOption("listener-param", StringUtils.join((Object[])listenerParametersValues, (String)","));
        }
        if (QueueCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        command.addOption("parallel", String.valueOf(Boolean.TRUE.equals(parallel)));
        command.addOption("enable-batch-conflation", String.valueOf(Boolean.TRUE.equals(enableBatchConflation)));
        command.addOption("forward-expiration-destroy", String.valueOf(forwardExpirationDestroy));
        if (QueueCommandsController.hasValue(batchSize)) {
            command.addOption("batch-size", String.valueOf(batchSize));
        }
        if (QueueCommandsController.hasValue(batchTimeInterval)) {
            command.addOption("batch-time-interval", String.valueOf(batchTimeInterval));
        }
        command.addOption("persistent", String.valueOf(Boolean.TRUE.equals(persistent)));
        if (QueueCommandsController.hasValue(diskStore)) {
            command.addOption("disk-store", diskStore);
        }
        command.addOption("disk-synchronous", String.valueOf(Boolean.TRUE.equals(diskSynchronous)));
        if (QueueCommandsController.hasValue(maxQueueMemory)) {
            command.addOption("max-queue-memory", String.valueOf(maxQueueMemory));
        }
        if (QueueCommandsController.hasValue(dispatcherThreads)) {
            command.addOption("dispatcher-threads", String.valueOf(dispatcherThreads));
        }
        if (QueueCommandsController.hasValue(orderPolicy)) {
            command.addOption("order-policy", orderPolicy);
        }
        if (QueueCommandsController.hasValue(gatewayEventFilters)) {
            command.addOption("gateway-event-filter", StringUtils.join((Object[])gatewayEventFilters, (String)","));
        }
        if (QueueCommandsController.hasValue(gatewaySubstitutionFilter)) {
            command.addOption("gateway-event-substitution-filter", gatewaySubstitutionFilter);
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async-event-queues"})
    @ResponseBody
    public String listAsyncEventQueues() {
        return this.processCommand("list async-event-queues");
    }
}

