/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="wanController")
@RequestMapping(value={"/v1"})
public class WanCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET}, value={"/gateways"})
    @ResponseBody
    public String listGateways(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("list gateways");
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/receivers"})
    @ResponseBody
    public String createGatewayReceiver(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="manual-start", required=false) Boolean manualStart, @RequestParam(value="member", required=false) String[] members, @RequestParam(value="start-port", required=false) Integer startPort, @RequestParam(value="end-port", required=false) Integer endPort, @RequestParam(value="bind-address", required=false) String bindAddress, @RequestParam(value="maximum-time-between-pings", required=false) Integer maximumTimeBetweenPings, @RequestParam(value="socket-buffer-size", required=false) Integer socketBufferSize, @RequestParam(value="gateway-transport-filter", required=false) String[] gatewayTransportFilters) {
        CommandStringBuilder command = new CommandStringBuilder("create gateway-receiver");
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(manualStart)) {
            command.addOption("manual-start", String.valueOf(manualStart));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        if (WanCommandsController.hasValue(startPort)) {
            command.addOption("start-port", String.valueOf(startPort));
        }
        if (WanCommandsController.hasValue(endPort)) {
            command.addOption("end-port", String.valueOf(endPort));
        }
        if (WanCommandsController.hasValue(bindAddress)) {
            command.addOption("bind-address", bindAddress);
        }
        if (WanCommandsController.hasValue(maximumTimeBetweenPings)) {
            command.addOption("maximum-time-between-pings", String.valueOf(maximumTimeBetweenPings));
        }
        if (WanCommandsController.hasValue(socketBufferSize)) {
            command.addOption("socket-buffer-size", String.valueOf(socketBufferSize));
        }
        if (WanCommandsController.hasValue(gatewayTransportFilters)) {
            command.addOption("gateway-transport-filter", StringUtils.join((Object[])gatewayTransportFilters, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/senders"})
    @ResponseBody
    public String createGatewaySender(@RequestParam(value="id") String gatewaySenderId, @RequestParam(value="remote-distributed-system-id") Integer remoteDistributedSystemId, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members, @RequestParam(value="parallel", required=false) Boolean parallel, @RequestParam(value="manual-start", required=false) Boolean manualStart, @RequestParam(value="socket-buffer-size", required=false) Integer socketBufferSize, @RequestParam(value="socket-read-timeout", required=false) Integer socketReadTimeout, @RequestParam(value="enable-batch-conflation", required=false) Boolean enableBatchConflation, @RequestParam(value="batch-size", required=false) Integer batchSize, @RequestParam(value="batch-time-interval", required=false) Integer batchTimeInterval, @RequestParam(value="enable-persistence", required=false) Boolean enablePersistence, @RequestParam(value="disk-store-name", required=false) String diskStoreName, @RequestParam(value="disk-synchronous", required=false) Boolean diskSynchronous, @RequestParam(value="maximum-queue-memory", required=false) Integer maxQueueMemory, @RequestParam(value="alert-threshold", required=false) Integer alertThreshold, @RequestParam(value="dispatcher-threads", required=false) Integer dispatcherThreads, @RequestParam(value="order-policy", required=false) String orderPolicy, @RequestParam(value="gateway-event-filter", required=false) String[] gatewayEventFilters, @RequestParam(value="gateway-transport-filter", required=false) String[] gatewayTransportFilters) {
        CommandStringBuilder command = new CommandStringBuilder("create gateway-sender");
        command.addOption("id", gatewaySenderId);
        command.addOption("remote-distributed-system-id", String.valueOf(remoteDistributedSystemId));
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        if (WanCommandsController.hasValue(parallel)) {
            command.addOption("parallel", String.valueOf(parallel));
        }
        if (WanCommandsController.hasValue(manualStart)) {
            command.addOption("manual-start", String.valueOf(manualStart));
        }
        if (WanCommandsController.hasValue(socketBufferSize)) {
            command.addOption("socket-buffer-size", String.valueOf(socketBufferSize));
        }
        if (WanCommandsController.hasValue(socketReadTimeout)) {
            command.addOption("socket-read-timeout", String.valueOf(socketReadTimeout));
        }
        if (WanCommandsController.hasValue(enableBatchConflation)) {
            command.addOption("enable-batch-conflation", String.valueOf(enableBatchConflation));
        }
        if (WanCommandsController.hasValue(batchSize)) {
            command.addOption("batch-size", String.valueOf(batchSize));
        }
        if (WanCommandsController.hasValue(batchTimeInterval)) {
            command.addOption("batch-time-interval", String.valueOf(batchTimeInterval));
        }
        if (WanCommandsController.hasValue(enablePersistence)) {
            command.addOption("enable-persistence", String.valueOf(enablePersistence));
        }
        if (WanCommandsController.hasValue(diskStoreName)) {
            command.addOption("disk-store-name", diskStoreName);
        }
        if (WanCommandsController.hasValue(diskSynchronous)) {
            command.addOption("disk-synchronous", String.valueOf(diskSynchronous));
        }
        if (WanCommandsController.hasValue(maxQueueMemory)) {
            command.addOption("maximum-queue-memory", String.valueOf(maxQueueMemory));
        }
        if (WanCommandsController.hasValue(alertThreshold)) {
            command.addOption("alert-threshold", String.valueOf(alertThreshold));
        }
        if (WanCommandsController.hasValue(dispatcherThreads)) {
            command.addOption("dispatcher-threads", String.valueOf(dispatcherThreads));
        }
        if (WanCommandsController.hasValue(orderPolicy)) {
            command.addOption("order-policy", orderPolicy);
        }
        if (WanCommandsController.hasValue(gatewayEventFilters)) {
            command.addOption("gateway-event-filter", StringUtils.join((Object[])gatewayEventFilters, (String)","));
        }
        if (WanCommandsController.hasValue(gatewayTransportFilters)) {
            command.addOption("gateway-transport-filter", StringUtils.join((Object[])gatewayTransportFilters, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/gateways/senders/{id}"})
    @ResponseBody
    public String destroyGatewaySender(@PathVariable(value="id") String gatewaySenderId, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("destroy gateway-sender");
        command.addOption("id", gatewaySenderId);
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/senders/{id}"}, params={"op=load-balance"})
    @ResponseBody
    public String loadBalanceGatewaySender(@PathVariable(value="id") String gatewaySenderId) {
        CommandStringBuilder command = new CommandStringBuilder("load-balance gateway-sender");
        command.addOption("id", WanCommandsController.decode(gatewaySenderId));
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/senders/{id}"}, params={"op=pause"})
    @ResponseBody
    public String pauseGatewaySender(@PathVariable(value="id") String gatewaySenderId, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("pause gateway-sender");
        command.addOption("id", WanCommandsController.decode(gatewaySenderId));
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/senders/{id}"}, params={"op=resume"})
    @ResponseBody
    public String resumeGatewaySender(@PathVariable(value="id") String gatewaySenderId, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("resume gateway-sender");
        command.addOption("id", WanCommandsController.decode(gatewaySenderId));
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/receivers"}, params={"op=start"})
    @ResponseBody
    public String startGatewayReceiver(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("start gateway-receiver");
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/senders"}, params={"op=start"})
    @ResponseBody
    public String startGatewaySender(@RequestParam(value="id") String gatewaySenderId, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("start gateway-sender");
        command.addOption("id", gatewaySenderId);
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/gateways/receivers"})
    @ResponseBody
    public String statusGatewayReceivers(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("status gateway-receiver");
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/gateways/senders/{id}"})
    @ResponseBody
    public String statusGatewaySenders(@PathVariable(value="id") String gatewaySenderId, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("status gateway-sender");
        command.addOption("id", WanCommandsController.decode(gatewaySenderId));
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/receivers"}, params={"op=stop"})
    @ResponseBody
    public String stopGatewayReceiver(@RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("stop gateway-receiver");
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/gateways/senders/{id}"}, params={"op=stop"})
    @ResponseBody
    public String stopGatewaySender(@PathVariable(value="id") String gatewaySenderId, @RequestParam(value="group", required=false) String[] groups, @RequestParam(value="member", required=false) String[] members) {
        CommandStringBuilder command = new CommandStringBuilder("stop gateway-sender");
        command.addOption("id", WanCommandsController.decode(gatewaySenderId));
        if (WanCommandsController.hasValue(groups)) {
            command.addOption("group", StringUtils.join((Object[])groups, (String)","));
        }
        if (WanCommandsController.hasValue(members)) {
            command.addOption("member", StringUtils.join((Object[])members, (String)","));
        }
        return this.processCommand(command.toString());
    }
}

