/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers.support;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.internal.web.util.UriUtils;
import org.apache.logging.log4j.Logger;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LoginHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LogService.getLogger();
    private Cache cache;
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();
    private static final ThreadLocal<Map<String, String>> ENV = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return Collections.emptyMap();
        }
    };
    protected static final String ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX = "vf.gf.env.";
    protected static final String SECURITY_VARIABLE_REQUEST_HEADER_PREFIX = "security-";

    public static Map<String, String> getEnvironment() {
        return ENV.get();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HashMap<String, String> requestParameterValues = new HashMap<String, String>();
        Enumeration requestParameters = request.getParameterNames();
        while (requestParameters.hasMoreElements()) {
            String requestParameter = (String)requestParameters.nextElement();
            if (!requestParameter.startsWith(ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX)) continue;
            String requestValue = request.getParameter(requestParameter);
            if (requestParameter.contains("stepArgs")) {
                requestValue = UriUtils.decode(requestValue);
            }
            requestParameterValues.put(requestParameter.substring(ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX.length()), requestValue);
        }
        ENV.set(requestParameterValues);
        String username = request.getHeader("security-username");
        String password = request.getHeader("security-password");
        Properties credentials = new Properties();
        if (username != null) {
            credentials.put("security-username", username);
        }
        if (password != null) {
            credentials.put("security-password", password);
        }
        this.securityService.login(credentials);
        return true;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.afterConcurrentHandlingStarted(request, response, handler);
        this.securityService.logout();
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ENV.remove();
    }
}

