/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.domain;

import java.io.Serializable;
import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.web.http.HttpMethod;
import org.apache.geode.management.internal.web.util.UriUtils;

@XmlType(name="link", propOrder={"method", "href", "relation"})
public class Link
implements Comparable<Link>,
Serializable {
    protected static final HttpMethod DEFAULT_HTTP_METHOD = HttpMethod.GET;
    protected static final String HREF_ATTRIBUTE_NAME = "href";
    protected static final String LINK_ELEMENT_NAME = "link";
    protected static final String METHOD_ATTRIBUTE_NAME = "method";
    protected static final String RELATION_ATTRIBUTE_NAME = "rel";
    private HttpMethod method;
    private String relation;
    private URI href;

    public Link() {
    }

    public Link(String relation, URI href) {
        this(relation, href, DEFAULT_HTTP_METHOD);
    }

    public Link(String relation, URI href, HttpMethod method) {
        this.setRelation(relation);
        this.setHref(href);
        this.setMethod(method);
    }

    @XmlAttribute(name="href")
    public URI getHref() {
        return this.href;
    }

    public void setHref(URI href) {
        assert (href != null) : "The Link href URI cannot be null!";
        this.href = href;
    }

    @XmlAttribute(name="method", required=false)
    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = (HttpMethod)((Object)ObjectUtils.defaultIfNull((Object[])new HttpMethod[]{method, DEFAULT_HTTP_METHOD}));
    }

    @XmlAttribute(name="rel")
    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        assert (StringUtils.isNotBlank((String)relation)) : "The Link relation (rel) must be specified!";
        this.relation = relation;
    }

    @Override
    public int compareTo(Link link) {
        int compareValue = this.getRelation().compareTo(link.getRelation());
        compareValue = compareValue != 0 ? compareValue : this.getHref().compareTo(link.getHref());
        return compareValue != 0 ? compareValue : this.getMethod().compareTo(link.getMethod());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link that = (Link)obj;
        return ObjectUtils.equals((Object)this.getHref(), (Object)that.getHref()) && ObjectUtils.equals((Object)((Object)this.getMethod()), (Object)((Object)that.getMethod()));
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode((Object)this.getHref());
        hashValue = 37 * hashValue + ObjectUtils.hashCode((Object)((Object)this.getMethod()));
        return hashValue;
    }

    public String toHttpRequestLine() {
        return this.getMethod().name().concat(" ").concat(UriUtils.decode(this.getHref().toString()));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ class = ").append(this.getClass().getName());
        buffer.append(", rel = ").append(this.getRelation());
        buffer.append(", href = ").append(this.getHref());
        buffer.append(", method = ").append((Object)this.getMethod());
        buffer.append(" }");
        return buffer.toString();
    }
}

