/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.geode.management.internal.web.domain.Link;

@XmlRootElement(name="link-index")
public class LinkIndex
implements Iterable<Link> {
    @XmlElement(name="link")
    private final Set<Link> links = new TreeSet<Link>();

    public LinkIndex add(Link link) {
        assert (link != null) : "The Link to add to the index cannot be null!";
        this.links.add(link);
        return this;
    }

    public LinkIndex addAll(Link ... links) {
        assert (links != null) : "The array of Links to add to this index cannot be null!";
        return this.addAll(Arrays.asList(links));
    }

    public LinkIndex addAll(Iterable<Link> links) {
        assert (links != null) : "The Iterable collection of Links to add to this index cannot be null!";
        for (Link link : links) {
            this.add(link);
        }
        return this;
    }

    public Link find(String relation) {
        Link linkFound = null;
        for (Link link : this) {
            if (!link.getRelation().equalsIgnoreCase(relation)) continue;
            linkFound = link;
            break;
        }
        return linkFound;
    }

    public Link[] findAll(String relation) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (Link link : this) {
            if (!link.getRelation().equalsIgnoreCase(relation)) continue;
            links.add(link);
        }
        return links.toArray(new Link[links.size()]);
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    @Override
    public Iterator<Link> iterator() {
        return Collections.unmodifiableSet(this.links).iterator();
    }

    public int size() {
        return this.links.size();
    }

    public List<Link> toList() {
        return new ArrayList<Link>(this.links);
    }

    public Map<String, List<Link>> toMap() {
        TreeMap<String, List<Link>> links = new TreeMap<String, List<Link>>();
        for (Link link : this) {
            ArrayList<Link> linksByRelation = (ArrayList<Link>)links.get(link.getRelation());
            if (linksByRelation == null) {
                linksByRelation = new ArrayList<Link>(this.size());
                links.put(link.getRelation(), linksByRelation);
            }
            linksByRelation.add(link);
        }
        return links;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("[");
        int count = 0;
        for (Link link : this) {
            buffer.append(count++ > 0 ? ", " : "").append(link);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

