/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.http;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.lang.Filter;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.util.CollectionUtils;
import org.apache.geode.management.internal.web.domain.Link;
import org.apache.geode.management.internal.web.util.UriUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ClientHttpRequest
implements HttpRequest {
    private final HttpHeaders requestHeaders = new HttpHeaders();
    private final Link link;
    private final MultiValueMap<String, Object> requestParameters = new LinkedMultiValueMap();
    private Object content;

    public ClientHttpRequest(Link link) {
        assert (link != null) : "The Link containing the URI and method for the client's HTTP request cannot be null!";
        this.link = link;
    }

    public HttpHeaders getHeaders() {
        return this.requestHeaders;
    }

    public Link getLink() {
        return this.link;
    }

    public HttpMethod getMethod() {
        switch (this.getLink().getMethod()) {
            case DELETE: {
                return HttpMethod.DELETE;
            }
            case HEAD: {
                return HttpMethod.HEAD;
            }
            case OPTIONS: {
                return HttpMethod.OPTIONS;
            }
            case POST: {
                return HttpMethod.POST;
            }
            case PUT: {
                return HttpMethod.PUT;
            }
            case TRACE: {
                return HttpMethod.TRACE;
            }
        }
        return HttpMethod.GET;
    }

    public boolean isDelete() {
        return HttpMethod.DELETE.equals((Object)this.getMethod());
    }

    public boolean isGet() {
        return HttpMethod.GET.equals((Object)this.getMethod());
    }

    public boolean isPost() {
        return HttpMethod.POST.equals((Object)this.getMethod());
    }

    public boolean isPut() {
        return HttpMethod.PUT.equals((Object)this.getMethod());
    }

    public MultiValueMap<String, Object> getParameters() {
        return this.requestParameters;
    }

    protected List<String> getPathVariables() {
        return Collections.unmodifiableList(new UriTemplate(UriUtils.decode(this.getURI().toString())).getVariableNames());
    }

    public URI getURI() {
        return this.getLink().getHref();
    }

    public URI getURL() {
        return this.getURL(Collections.emptyMap());
    }

    public URI getURL(Map<String, ?> uriVariables) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)UriUtils.decode(this.getURI().toString()));
        if (this.isGet() || this.isDelete()) {
            final List<String> pathVariables = this.getPathVariables();
            Map queryParameters = CollectionUtils.removeKeys((Map)new LinkedMultiValueMap(this.getParameters()), (Filter)new Filter<Map.Entry<String, List<Object>>>(){

                public boolean accept(Map.Entry<String, List<Object>> entry) {
                    List<Object> stepArgsList;
                    if (entry.getKey().contains("stepArgs") && (stepArgsList = entry.getValue()) != null) {
                        String stepArgs = (String)stepArgsList.remove(0);
                        stepArgsList.add(UriUtils.encode(stepArgs));
                    }
                    return !pathVariables.contains(entry.getKey());
                }
            });
            for (String queryParameterName : queryParameters.keySet()) {
                uriBuilder.queryParam(queryParameterName, ((List)this.getParameters().get((Object)queryParameterName)).toArray());
            }
        }
        return uriBuilder.build().expand(UriUtils.encode(new HashMap<String, Object>(uriVariables))).encode().toUri();
    }

    public HttpEntity<?> createRequestEntity() {
        if (this.isPost() || this.isPut()) {
            if (!this.getParameters().isEmpty()) {
                this.getHeaders().setContentType(this.determineContentType(MediaType.APPLICATION_FORM_URLENCODED));
                return new HttpEntity(this.getParameters(), (MultiValueMap)this.getHeaders());
            }
            return new HttpEntity(this.getContent(), (MultiValueMap)this.getHeaders());
        }
        return new HttpEntity((MultiValueMap)this.getHeaders());
    }

    protected MediaType determineContentType(MediaType defaultContentType) {
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType == null && (this.isPost() || this.isPut())) {
            block0: for (String name : this.getParameters().keySet()) {
                for (Object value : (List)this.getParameters().get((Object)name)) {
                    if (value == null || value instanceof String) continue;
                    contentType = MediaType.MULTIPART_FORM_DATA;
                    break block0;
                }
            }
            contentType = (MediaType)ObjectUtils.defaultIfNull((Object[])new MediaType[]{contentType, MediaType.APPLICATION_FORM_URLENCODED});
        }
        return (MediaType)ObjectUtils.defaultIfNull((Object[])new MediaType[]{contentType, defaultContentType});
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void addHeaderValues(String headerName, String ... headerValues) {
        if (headerValues != null) {
            for (String headerValue : headerValues) {
                this.getHeaders().add(headerName, headerValue);
            }
        }
    }

    public String getHeaderValue(String headerName) {
        return this.getHeaders().getFirst(headerName);
    }

    public List<String> getHeaderValues(String headerName) {
        return Collections.unmodifiableList(this.getHeaders().get((Object)headerName));
    }

    public void setHeader(String headerName, String headerValue) {
        this.getHeaders().set(headerName, headerValue);
    }

    public void addParameterValues(String requestParameterName, Object ... requestParameterValues) {
        if (requestParameterValues != null) {
            for (Object requestParameterValue : requestParameterValues) {
                this.getParameters().add((Object)requestParameterName, requestParameterValue);
            }
        }
    }

    public Object getParameterValue(String requestParameterName) {
        return this.getParameters().getFirst((Object)requestParameterName);
    }

    public List<Object> getParameterValues(String requestParameterName) {
        return Collections.unmodifiableList((List)this.getParameters().get((Object)requestParameterName));
    }

    public void setParameter(String name, Object value) {
        this.getParameters().set((Object)name, value);
    }
}

