/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.http.support;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class SimpleHttpRequester {
    protected static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private final RestTemplate restTemplate;
    private String user;
    private String pwd;
    private Map<String, String> securityProperties;

    public SimpleHttpRequester(Gfsh gfsh, Map<String, String> securityProperties) {
        this(gfsh, 30000, securityProperties);
    }

    public SimpleHttpRequester(Gfsh gfsh, int connectTimeout, Map<String, String> securityProperties) {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(connectTimeout);
        this.securityProperties = securityProperties;
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        this.restTemplate.setErrorHandler(new ResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse response) throws IOException {
                HttpStatus status = response.getStatusCode();
                switch (status) {
                    case BAD_REQUEST: 
                    case UNAUTHORIZED: 
                    case FORBIDDEN: 
                    case NOT_FOUND: 
                    case METHOD_NOT_ALLOWED: 
                    case NOT_ACCEPTABLE: 
                    case REQUEST_TIMEOUT: 
                    case CONFLICT: 
                    case REQUEST_ENTITY_TOO_LARGE: 
                    case REQUEST_URI_TOO_LONG: 
                    case UNSUPPORTED_MEDIA_TYPE: 
                    case TOO_MANY_REQUESTS: 
                    case INTERNAL_SERVER_ERROR: 
                    case NOT_IMPLEMENTED: 
                    case BAD_GATEWAY: 
                    case SERVICE_UNAVAILABLE: {
                        return true;
                    }
                }
                return false;
            }

            public void handleError(ClientHttpResponse response) throws IOException {
                String message = String.format("The HTTP request failed with: %1$d - %2$s", response.getRawStatusCode(), response.getStatusText());
                if (response.getRawStatusCode() == 401) {
                    throw new AuthenticationFailedException(message);
                }
                if (response.getRawStatusCode() == 403) {
                    throw new NotAuthorizedException(message);
                }
                throw new RuntimeException(message);
            }
        });
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void delete(String url, Object ... urlVariables) {
        this.getRestTemplate().delete(url, urlVariables);
    }

    public <T> T get(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)this.getRestTemplate().getForObject(url, responseType, urlVariables);
    }

    public HttpHeaders headers(String url, Object ... urlVariables) {
        return this.getRestTemplate().headForHeaders(url, urlVariables);
    }

    public Set<HttpMethod> options(String url, Object ... urlVariables) {
        return this.getRestTemplate().optionsForAllow(url, urlVariables);
    }

    public <T> T post(String url, Object requestBody, Class<T> responseType, Object ... urlVariables) {
        return (T)this.getRestTemplate().postForObject(url, requestBody, responseType, urlVariables);
    }

    public void put(String url, Object requestBody, Object ... urlVariables) {
        this.getRestTemplate().put(url, requestBody, urlVariables);
    }

    public <T> T exchange(String url, Class<T> responseType, Object ... urlVariables) {
        ResponseEntity response = this.getRestTemplate().exchange(url, HttpMethod.GET, this.getRequestEntity(), responseType, new Object[0]);
        return (T)response.getBody();
    }

    protected HttpEntity<?> getRequestEntity() {
        HttpHeaders requestHeaders = new HttpHeaders();
        if (this.securityProperties != null) {
            requestHeaders.setAll(this.securityProperties);
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)requestHeaders);
        return requestEntity;
    }
}

