/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.shell;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.commons.io.FileUtils;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.web.domain.Link;
import org.apache.geode.management.internal.web.domain.QueryParameterSource;
import org.apache.geode.management.internal.web.http.ClientHttpRequest;
import org.apache.geode.management.internal.web.http.HttpHeader;
import org.apache.geode.management.internal.web.http.converter.SerializableObjectHttpMessageConverter;
import org.apache.geode.management.internal.web.shell.HttpOperationInvoker;
import org.apache.geode.management.internal.web.shell.MBeanAccessException;
import org.apache.geode.management.internal.web.shell.RestApiCallForCommandNotFoundException;
import org.apache.geode.management.internal.web.shell.support.HttpMBeanProxyFactory;
import org.apache.geode.management.internal.web.util.UriUtils;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractHttpOperationInvoker
implements HttpOperationInvoker {
    protected static final long DEFAULT_INITIAL_DELAY = TimeUnit.SECONDS.toMillis(1L);
    protected static final long DEFAULT_PERIOD = TimeUnit.MILLISECONDS.toMillis(2000L);
    protected static final String MBEAN_ATTRIBUTE_LINK_RELATION = "mbean-attribute";
    protected static final String MBEAN_OPERATION_LINK_RELATION = "mbean-operation";
    protected static final String MBEAN_QUERY_LINK_RELATION = "mbean-query";
    protected static final String PING_LINK_RELATION = "ping";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String REST_API_BASE_URL = "http://localhost:8080";
    protected static final String REST_API_VERSION = "/v1";
    protected static final String REST_API_WEB_APP_CONTEXT = "/gemfire";
    protected static final String REST_API_URL = "http://localhost:8080/gemfire/v1";
    protected static final String USER_AGENT_HTTP_REQUEST_HEADER_VALUE = "GemFire-Shell/v" + GemFireVersion.getGemFireVersion();
    protected static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private Integer clusterId = -1;
    private final ScheduledExecutorService executorService;
    private final Gfsh gfsh;
    private final List<MediaType> acceptableMediaTypes = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN);
    private final Logger logger = LogService.getLogger();
    private volatile RestTemplate restTemplate;
    private final String baseUrl;
    protected Map<String, String> securityProperties;

    AbstractHttpOperationInvoker(String baseUrl) {
        this.baseUrl = baseUrl;
        this.executorService = null;
        this.gfsh = null;
        this.restTemplate = null;
    }

    public AbstractHttpOperationInvoker(Gfsh gfsh, Map<String, String> securityProperties) {
        this(gfsh, REST_API_URL, securityProperties);
    }

    public AbstractHttpOperationInvoker(final Gfsh gfsh, String baseUrl, Map<String, String> securityProperties) {
        AbstractHttpOperationInvoker.assertNotNull(gfsh, "The reference to the GemFire shell (Gfsh) cannot be null!", new Object[0]);
        this.gfsh = gfsh;
        this.baseUrl = StringUtils.defaultIfBlank((String)baseUrl, (String)REST_API_URL);
        this.securityProperties = securityProperties;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
        List converters = this.restTemplate.getMessageConverters();
        for (int i = converters.size() - 1; i >= 0; --i) {
            HttpMessageConverter converter = (HttpMessageConverter)converters.get(i);
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            converters.remove(converter);
        }
        converters.add(new SerializableObjectHttpMessageConverter());
        this.restTemplate.setErrorHandler(new ResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse response) throws IOException {
                HttpStatus status = response.getStatusCode();
                switch (status) {
                    case BAD_REQUEST: 
                    case UNAUTHORIZED: 
                    case FORBIDDEN: 
                    case NOT_FOUND: 
                    case METHOD_NOT_ALLOWED: 
                    case NOT_ACCEPTABLE: 
                    case REQUEST_TIMEOUT: 
                    case CONFLICT: 
                    case REQUEST_ENTITY_TOO_LARGE: 
                    case REQUEST_URI_TOO_LONG: 
                    case UNSUPPORTED_MEDIA_TYPE: 
                    case TOO_MANY_REQUESTS: 
                    case INTERNAL_SERVER_ERROR: 
                    case NOT_IMPLEMENTED: 
                    case BAD_GATEWAY: 
                    case SERVICE_UNAVAILABLE: {
                        return true;
                    }
                }
                return false;
            }

            public void handleError(ClientHttpResponse response) throws IOException {
                String body = this.readBody(response);
                String message = String.format("The HTTP request failed with: %1$d - %2$s.", response.getRawStatusCode(), body);
                if (gfsh.getDebug()) {
                    gfsh.logSevere(body, null);
                }
                if (response.getRawStatusCode() == 401) {
                    throw new AuthenticationFailedException(message);
                }
                if (response.getRawStatusCode() == 403) {
                    throw new NotAuthorizedException(message);
                }
                throw new RuntimeException(message);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String readBody(ClientHttpResponse response) throws IOException {
                String string;
                BufferedReader responseBodyReader = null;
                try {
                    String line;
                    responseBodyReader = new BufferedReader(new InputStreamReader(response.getBody()));
                    StringBuilder buffer = new StringBuilder();
                    while ((line = responseBodyReader.readLine()) != null) {
                        buffer.append(line).append(StringUtils.LINE_SEPARATOR);
                    }
                    string = buffer.toString().trim();
                }
                catch (Throwable throwable) {
                    IOUtils.close(responseBodyReader);
                    throw throwable;
                }
                IOUtils.close((Closeable)responseBodyReader);
                return string;
            }
        });
    }

    protected static void assertArgument(boolean validArg, String message, Object ... args) {
        if (!validArg) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    protected static void assertNotNull(Object obj, String message, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(String.format(message, args));
        }
    }

    protected static void assertState(boolean validState, String message, Object ... args) {
        if (!validState) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    protected List<MediaType> getAcceptableMediaTypes() {
        return this.acceptableMediaTypes;
    }

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    protected boolean isDebugEnabled() {
        return this.getGfsh().getDebug();
    }

    protected ScheduledExecutorService getExecutorService() {
        AbstractHttpOperationInvoker.assertState(this.executorService != null, "The ExecutorService for this HTTP OperationInvoker (%1$s) was not properly initialized!", this.getClass().getName());
        return this.executorService;
    }

    protected Gfsh getGfsh() {
        return this.gfsh;
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected ClientHttpRequest createHttpRequest(Link link) {
        ClientHttpRequest request = new ClientHttpRequest(link);
        request.addHeaderValues(HttpHeader.USER_AGENT.getName(), USER_AGENT_HTTP_REQUEST_HEADER_VALUE);
        request.getHeaders().setAccept(this.getAcceptableMediaTypes());
        if (this.securityProperties != null) {
            for (Map.Entry<String, String> entry : this.securityProperties.entrySet()) {
                request.addHeaderValues(entry.getKey(), entry.getValue());
            }
        }
        return request;
    }

    protected Link createLink(String relation, URI href) {
        return new Link(relation, href);
    }

    protected Link createLink(String relation, URI href, org.apache.geode.management.internal.web.http.HttpMethod method) {
        return new Link(relation, href, method);
    }

    protected String decode(String encodedValue) {
        return UriUtils.decode(encodedValue);
    }

    protected String decode(String encodedValue, String encoding) {
        return UriUtils.decode(encodedValue, encoding);
    }

    protected String encode(String value) {
        return UriUtils.encode(value);
    }

    protected String encode(String value, String encoding) {
        return UriUtils.encode(value, encoding);
    }

    protected Link findLink(String relation) {
        return null;
    }

    protected String handleResourceAccessException(ResourceAccessException e) {
        this.stop();
        return String.format("The connection to the GemFire Manager's HTTP service @ %1$s failed with: %2$s. Please try reconnecting or see the GemFire Manager's log file for further details.", this.getBaseUrl(), e.getMessage());
    }

    protected void printDebug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.printInfo(message, args);
        }
    }

    protected void printInfo(String message, Object ... args) {
        this.getGfsh().printAsInfo(String.format(message, args));
    }

    protected void printWarning(String message, Object ... args) {
        this.getGfsh().printAsWarning(String.format(message, args));
    }

    protected void printSevere(String message, Object ... args) {
        this.getGfsh().printAsSevere(String.format(message, args));
    }

    protected <T> T send(ClientHttpRequest request, Class<T> responseType) {
        return this.send(request, responseType, Collections.emptyMap());
    }

    protected <T> T send(ClientHttpRequest request, Class<T> responseType, Map<String, ?> uriVariables) {
        URI url = request.getURL(uriVariables);
        if (this.isDebugEnabled()) {
            this.printInfo("Link: %1$s", request.getLink().toHttpRequestLine());
            this.printInfo("HTTP URL: %1$s", url);
            this.printInfo("HTTP request headers: %1$s", request.getHeaders());
            this.printInfo("HTTP request parameters: %1$s", request.getParameters());
        }
        ResponseEntity response = this.getRestTemplate().exchange(url, request.getMethod(), request.createRequestEntity(), responseType);
        if (this.isDebugEnabled()) {
            this.printInfo("------------------------------------------------------------------------", new Object[0]);
            this.printInfo("HTTP response headers: %1$s", response.getHeaders());
            this.printInfo("HTTP response status: %1$d - %2$s", response.getStatusCode().value(), response.getStatusCode().getReasonPhrase());
            this.printInfo("HTTP response body: ", response.getBody());
        }
        return (T)response.getBody();
    }

    protected Object downloadResponseToTempFile(ClientHttpRequest request, Map<String, ?> uriVariables) {
        URI url = request.getURL(uriVariables);
        RequestCallback requestCallback = r -> {
            r.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
            HttpHeaders header = request.getHeaders();
            r.getHeaders().setAll(request.getHeaders().toSingleValueMap());
        };
        ResponseExtractor responseExtractor = resp -> {
            MediaType mediaType = resp.getHeaders().getContentType();
            if (mediaType.equals((Object)MediaType.APPLICATION_JSON)) {
                return org.apache.commons.io.IOUtils.toString((InputStream)resp.getBody(), (String)DEFAULT_ENCODING);
            }
            Path tempFile = Files.createTempFile("fileDownload", "", new FileAttribute[0]);
            if (tempFile.toFile().exists()) {
                FileUtils.deleteQuietly((File)tempFile.toFile());
            }
            Files.copy(resp.getBody(), tempFile, new CopyOption[0]);
            return tempFile;
        };
        return this.getRestTemplate().execute(url, HttpMethod.GET, requestCallback, responseExtractor);
    }

    public boolean isConnected() {
        return this.getRestTemplate() != null;
    }

    public boolean isReady() {
        return this.isConnected();
    }

    public Object getAttribute(String resourceName, String attributeName) {
        Link link = this.findLink(MBEAN_ATTRIBUTE_LINK_RELATION);
        if (link != null) {
            ClientHttpRequest request = this.createHttpRequest(link);
            request.addParameterValues("resourceName", resourceName);
            request.addParameterValues("attributeName", attributeName);
            try {
                return IOUtils.deserializeObject((byte[])this.send(request, byte[].class));
            }
            catch (IOException e) {
                throw new MBeanAccessException(String.format("De-serializing the result of accessing attribute (%1$s) on MBean (%2$s) failed!", resourceName, attributeName), e);
            }
            catch (ClassNotFoundException e) {
                throw new MBeanAccessException(String.format("The Class type of the result when accessing attribute (%1$s) on MBean (%2$s) was not found!", resourceName, attributeName), e);
            }
        }
        this.printSevere("Getting the value of attribute (%1$s) on MBean (%2$s) is currently an unsupported operation!", attributeName, resourceName);
        throw new RestApiCallForCommandNotFoundException(MBEAN_ATTRIBUTE_LINK_RELATION);
    }

    public int getClusterId() {
        return this.clusterId;
    }

    protected void initClusterId() {
        if (this.isReady()) {
            try {
                this.clusterId = (Integer)this.getAttribute("GemFire:service=System,type=Distributed", "DistributedSystemId");
                this.printDebug("Cluster ID (%1$s)", this.clusterId);
            }
            catch (Exception ignore) {
                this.printDebug("Failed to determine cluster ID: %1$s", ignore.getMessage());
            }
        }
    }

    public DistributedSystemMXBean getDistributedSystemMXBean() {
        return this.getMBeanProxy(MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
    }

    public <T> T getMBeanProxy(ObjectName objectName, Class<T> mbeanInterface) {
        return HttpMBeanProxyFactory.createMBeanProxy(this, objectName, mbeanInterface);
    }

    public Object invoke(String resourceName, String operationName, Object[] params, String[] signature) {
        Link link = this.findLink(MBEAN_OPERATION_LINK_RELATION);
        if (link != null) {
            ClientHttpRequest request = this.createHttpRequest(link);
            request.addParameterValues("resourceName", resourceName);
            request.addParameterValues("operationName", operationName);
            request.addParameterValues("signature", signature);
            request.addParameterValues("parameters", params);
            try {
                return IOUtils.deserializeObject((byte[])this.send(request, byte[].class));
            }
            catch (IOException e) {
                throw new MBeanAccessException(String.format("De-serializing the result from invoking operation (%1$s) on MBean (%2$s) failed!", resourceName, operationName), e);
            }
            catch (ClassNotFoundException e) {
                throw new MBeanAccessException(String.format("The Class type of the result from invoking operation (%1$s) on MBean (%2$s) was not found!", resourceName, operationName), e);
            }
        }
        this.printSevere("Invoking operation (%1$s) on MBean (%2$s) is currently an unsupported operation!", operationName, resourceName);
        throw new RestApiCallForCommandNotFoundException(MBEAN_OPERATION_LINK_RELATION);
    }

    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExpression) {
        Link link = this.findLink(MBEAN_QUERY_LINK_RELATION);
        if (link != null) {
            ClientHttpRequest request = this.createHttpRequest(link);
            request.setContent(new QueryParameterSource(objectName, queryExpression));
            try {
                return (Set)IOUtils.deserializeObject((byte[])this.send(request, byte[].class));
            }
            catch (Exception e) {
                throw new MBeanAccessException(String.format("An error occurred while querying for MBean names using ObjectName pattern (%1$s) and Query expression (%2$s)!", objectName, queryExpression), e);
            }
        }
        this.printSevere("Running a query to get the ObjectNames of all MBeans matching the ObjectName pattern (%1$s) and Query expression (%2$s) is currently unsupported!", objectName, queryExpression);
        throw new RestApiCallForCommandNotFoundException(MBEAN_QUERY_LINK_RELATION);
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.restTemplate = null;
    }

    public String toString() {
        return String.format("GemFire Manager HTTP service @ %1$s", this.getBaseUrl());
    }
}

