/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.lang.Filter;
import org.apache.geode.internal.lang.Initable;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.CollectionUtils;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.web.domain.Link;
import org.apache.geode.management.internal.web.domain.LinkIndex;
import org.apache.geode.management.internal.web.http.ClientHttpRequest;
import org.apache.geode.management.internal.web.http.HttpHeader;
import org.apache.geode.management.internal.web.shell.AbstractHttpOperationInvoker;
import org.apache.geode.management.internal.web.shell.HttpOperationInvoker;
import org.apache.geode.management.internal.web.shell.RestApiCallForCommandNotFoundException;
import org.apache.geode.management.internal.web.shell.SimpleHttpOperationInvoker;
import org.apache.geode.management.internal.web.util.ConvertUtils;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.util.UriTemplate;

public class RestHttpOperationInvoker
extends AbstractHttpOperationInvoker
implements Initable {
    private static final Logger logger = LogService.getLogger();
    protected static final String ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX = "vf.gf.env.";
    protected static final String RESOURCES_REQUEST_PARAMETER = "resources";
    private final HttpOperationInvoker httpOperationInvoker;
    private final LinkIndex linkIndex;

    RestHttpOperationInvoker(LinkIndex linkIndex) {
        super("http://localhost:8080/gemfire/v1");
        RestHttpOperationInvoker.assertNotNull(linkIndex, "The Link Index resolving commands to REST API web service endpoints cannot be null!", new Object[0]);
        this.linkIndex = linkIndex;
        this.httpOperationInvoker = new SimpleHttpOperationInvoker();
    }

    public RestHttpOperationInvoker(LinkIndex linkIndex, Gfsh gfsh, Map<String, String> securityProperties) {
        this(linkIndex, gfsh, "http://localhost:7070/gemfire/v1", securityProperties);
    }

    public RestHttpOperationInvoker(LinkIndex linkIndex, Gfsh gfsh, String baseUrl, Map<String, String> securityProperties) {
        super(gfsh, baseUrl, securityProperties);
        RestHttpOperationInvoker.assertNotNull(linkIndex, "The Link Index resolving commands to REST API web service endpoints cannot be null!", new Object[0]);
        this.linkIndex = linkIndex;
        this.httpOperationInvoker = new SimpleHttpOperationInvoker(gfsh, baseUrl, securityProperties);
    }

    public void init() {
        final Link pingLink = this.getLinkIndex().find("ping");
        if (pingLink != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling periodic HTTP ping requests to monitor the availability of the GemFire Manager HTTP service @ ({})", (Object)this.getBaseUrl());
            }
            this.getExecutorService().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientHttpResponse httpResponse;
                        org.springframework.http.client.ClientHttpRequest httpRequest = RestHttpOperationInvoker.this.getRestTemplate().getRequestFactory().createRequest(pingLink.getHref(), HttpMethod.HEAD);
                        httpRequest.getHeaders().set(HttpHeader.USER_AGENT.getName(), AbstractHttpOperationInvoker.USER_AGENT_HTTP_REQUEST_HEADER_VALUE);
                        httpRequest.getHeaders().setAccept(RestHttpOperationInvoker.this.getAcceptableMediaTypes());
                        httpRequest.getHeaders().setContentLength(0L);
                        if (RestHttpOperationInvoker.this.securityProperties != null) {
                            for (Map.Entry entry : RestHttpOperationInvoker.this.securityProperties.entrySet()) {
                                httpRequest.getHeaders().add((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        if (HttpStatus.NOT_FOUND.equals((Object)(httpResponse = httpRequest.execute()).getStatusCode())) {
                            throw new IOException(String.format("The HTTP service at URL (%1$s) could not be found!", pingLink.getHref()));
                        }
                        if (!HttpStatus.OK.equals((Object)httpResponse.getStatusCode())) {
                            RestHttpOperationInvoker.this.printDebug("Received unexpected HTTP status code (%1$d - %2$s) for HTTP request (%3$s).", httpResponse.getRawStatusCode(), httpResponse.getStatusText(), pingLink.getHref());
                        }
                    }
                    catch (IOException e) {
                        RestHttpOperationInvoker.this.printDebug("An error occurred while connecting to the Manager's HTTP service: %1$s: ", e.getMessage());
                        RestHttpOperationInvoker.this.getGfsh().notifyDisconnect(RestHttpOperationInvoker.this.toString());
                        RestHttpOperationInvoker.this.stop();
                    }
                }
            }, DEFAULT_INITIAL_DELAY, DEFAULT_PERIOD, DEFAULT_TIME_UNIT);
        } else if (logger.isDebugEnabled()) {
            logger.debug("The Link to the GemFire Manager web service endpoint @ ({}) to monitor availability was not found!", (Object)this.getBaseUrl());
        }
        this.initClusterId();
    }

    protected HttpOperationInvoker getHttpOperationInvoker() {
        return this.httpOperationInvoker;
    }

    protected LinkIndex getLinkIndex() {
        return this.linkIndex;
    }

    protected ClientHttpRequest createHttpRequest(CommandRequest command) {
        ClientHttpRequest request = this.createHttpRequest(this.findLink(command));
        Map commandParameters = command.getParameters();
        for (Map.Entry entry : commandParameters.entrySet()) {
            if (!NullValueFilter.INSTANCE.accept(entry)) continue;
            request.addParameterValues((String)entry.getKey(), entry.getValue());
        }
        Map environmentVariables = command.getEnvironment();
        for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
            if (!EnvironmentVariableFilter.INSTANCE.accept(entry)) continue;
            request.addParameterValues(ENVIRONMENT_VARIABLE_REQUEST_PARAMETER_PREFIX + entry.getKey(), entry.getValue());
        }
        if (command.getFileData() != null) {
            request.addParameterValues(RESOURCES_REQUEST_PARAMETER, ConvertUtils.convert(command.getFileData()));
        }
        return request;
    }

    @Override
    protected Link findLink(String relation) {
        return this.getLinkIndex().find(relation);
    }

    protected Link findLink(CommandRequest command) {
        ArrayList<Link> linksFound = new ArrayList<Link>(this.getLinkIndex().size());
        for (Link link : this.getLinkIndex()) {
            if (!command.getInput().startsWith(link.getRelation())) continue;
            linksFound.add(link);
        }
        if (linksFound.isEmpty()) {
            throw new RestApiCallForCommandNotFoundException(String.format("No REST API call for command (%1$s) was found!", command.getInput()));
        }
        return linksFound.size() > 1 ? this.resolveLink(command, linksFound) : (Link)linksFound.get(0);
    }

    protected Link resolveLink(CommandRequest command, List<Link> links) {
        Map commandParametersCopy = CollectionUtils.removeKeys(new HashMap(command.getParameters()), (Filter)NoValueFilter.INSTANCE);
        Link resolvedLink = null;
        int pathVariableCount = 0;
        for (Link link : links) {
            List pathVariables = new UriTemplate(this.decode(link.getHref().toString())).getVariableNames();
            if (!commandParametersCopy.keySet().containsAll(pathVariables) || resolvedLink != null && pathVariables.size() <= pathVariableCount) continue;
            resolvedLink = link;
            pathVariableCount = pathVariables.size();
        }
        if (resolvedLink == null) {
            throw new RestApiCallForCommandNotFoundException(String.format("No REST API call for command (%1$s) was found!", command.getInput()));
        }
        return resolvedLink;
    }

    public Object processCommand(CommandRequest command) {
        RestHttpOperationInvoker.assertState(this.isConnected(), "Gfsh must be connected to the GemFire Manager in order to process commands remotely!", new Object[0]);
        Object result = null;
        try {
            result = command.isDownloadFile() ? this.downloadResponseToTempFile(this.createHttpRequest(command), command.getParameters()) : this.send(this.createHttpRequest(command), String.class, command.getParameters());
            return result;
        }
        catch (RestApiCallForCommandNotFoundException e) {
            return this.simpleProcessCommand(command, e);
        }
        catch (ResourceAccessException e) {
            return this.handleResourceAccessException(e);
        }
    }

    protected String simpleProcessCommand(CommandRequest command, RestApiCallForCommandNotFoundException e) {
        if (this.getHttpOperationInvoker() != null) {
            this.printWarning("WARNING - No REST API web service endpoint (URI) exists for command (%1$s); using the non-RESTful, simple URI.", command.getName());
            return String.valueOf(this.getHttpOperationInvoker().processCommand(command));
        }
        throw e;
    }

    protected static class NullValueFilter
    implements Filter<Map.Entry<String, ?>> {
        protected static final NullValueFilter INSTANCE = new NullValueFilter();

        protected NullValueFilter() {
        }

        public boolean accept(Map.Entry<String, ?> entry) {
            return entry.getValue() != null;
        }
    }

    protected static class NoValueFilter
    implements Filter<Map.Entry<String, String>> {
        protected static final NoValueFilter INSTANCE = new NoValueFilter();

        protected NoValueFilter() {
        }

        public boolean accept(Map.Entry<String, String> entry) {
            return StringUtils.isNotBlank((String)entry.getValue());
        }
    }

    protected static class EnvironmentVariableFilter
    extends NoValueFilter {
        protected static final EnvironmentVariableFilter INSTANCE = new EnvironmentVariableFilter();

        protected EnvironmentVariableFilter() {
        }

        @Override
        public boolean accept(Map.Entry<String, String> entry) {
            return !entry.getKey().startsWith("SYS") && super.accept(entry);
        }
    }
}

