/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.shell;

import java.net.URI;
import java.util.Map;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.web.domain.Link;
import org.apache.geode.management.internal.web.http.ClientHttpRequest;
import org.apache.geode.management.internal.web.http.HttpMethod;
import org.apache.geode.management.internal.web.shell.AbstractHttpOperationInvoker;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.util.UriComponentsBuilder;

public class SimpleHttpOperationInvoker
extends AbstractHttpOperationInvoker {
    protected static final String CMD_QUERY_PARAMETER = "cmd";
    protected static final String LINK_RELATION = "simple";
    protected static final String REST_API_MANAGEMENT_COMMANDS_URI = "/management/commands";

    SimpleHttpOperationInvoker() {
        super("http://localhost:8080/gemfire/v1");
    }

    public SimpleHttpOperationInvoker(Gfsh gfsh, Map<String, String> securityProperties) {
        this(gfsh, "http://localhost:8080/gemfire/v1", securityProperties);
    }

    public SimpleHttpOperationInvoker(Gfsh gfsh, String baseUrl, Map<String, String> securityProperties) {
        super(gfsh, baseUrl, securityProperties);
    }

    protected ClientHttpRequest createHttpRequest(CommandRequest command) {
        return this.createHttpRequest(this.createLink(command));
    }

    protected Link createLink(CommandRequest command) {
        return this.createLink(LINK_RELATION, this.getHttpRequestUrl(command), HttpMethod.POST);
    }

    protected URI getHttpRequestUrl(CommandRequest command) {
        return UriComponentsBuilder.fromHttpUrl((String)this.getBaseUrl()).path(REST_API_MANAGEMENT_COMMANDS_URI).queryParam(CMD_QUERY_PARAMETER, new Object[]{command.getInput()}).build().encode().toUri();
    }

    public String processCommand(CommandRequest command) {
        SimpleHttpOperationInvoker.assertState(this.isConnected(), "Gfsh must be connected to the GemFire Manager in order to process commands remotely!", new Object[0]);
        try {
            return this.send(this.createHttpRequest(command), String.class);
        }
        catch (ResourceAccessException e) {
            return this.handleResourceAccessException(e);
        }
    }
}

