/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.web.io.MultipartFileResourceAdapter;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;

public abstract class ConvertUtils {
    public static Resource[] convert(byte[][] fileData) {
        if (fileData != null) {
            String[] fileNames = CliUtil.bytesToNames((byte[][])fileData);
            byte[][] fileContent = CliUtil.bytesToData((byte[][])fileData);
            ArrayList<1> resources = new ArrayList<1>(fileNames.length);
            for (int index = 0; index < fileNames.length; ++index) {
                final String filename = fileNames[index];
                resources.add(new ByteArrayResource(fileContent[index], String.format("Contents of JAR file (%1$s).", filename)){

                    public String getFilename() {
                        return filename;
                    }
                });
            }
            return resources.toArray(new Resource[resources.size()]);
        }
        return new Resource[0];
    }

    public static byte[][] convert(MultipartFile ... files) throws IOException {
        if (files != null) {
            ArrayList<MultipartFileResourceAdapter> resources = new ArrayList<MultipartFileResourceAdapter>(files.length);
            for (MultipartFile file : files) {
                resources.add(new MultipartFileResourceAdapter(file));
            }
            return ConvertUtils.convert(resources.toArray(new Resource[resources.size()]));
        }
        return new byte[0][];
    }

    public static byte[][] convert(Resource ... resources) throws IOException {
        if (resources != null) {
            ArrayList<byte[]> fileData = new ArrayList<byte[]>(resources.length * 2);
            for (Resource resource : resources) {
                if (StringUtils.isBlank((String)resource.getFilename())) {
                    throw new IllegalArgumentException(String.format("The filename of Resource (%1$s) must be specified!", resource.getDescription()));
                }
                fileData.add(resource.getFilename().getBytes());
                fileData.add(IOUtils.toByteArray((InputStream)resource.getInputStream()));
            }
            return (byte[][])fileData.toArray((T[])new byte[fileData.size()][]);
        }
        return new byte[0][];
    }
}

