/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.HashSet;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.AuthorizeRequest;

public class CloseCQ
extends BaseCQCommand {
    private static final CloseCQ singleton = new CloseCQ();

    public static Command getCommand() {
        return singleton;
    }

    private CloseCQ() {
    }

    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        ClientProxyMembershipID id = serverConnection.getProxyID();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        start = DistributionStats.getStatTime();
        String cqName = clientMessage.getPart(0).getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received close CQ request from {} cqName: {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)cqName);
        }
        if (cqName == null) {
            String err = LocalizedStrings.CloseCQ_THE_CQNAME_FOR_THE_CQ_CLOSE_REQUEST_IS_NULL.toLocalizedString();
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        this.securityService.authorizeDataManage();
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            String serverCqName = cqName;
            if (id != null) {
                serverCqName = cqService.constructServerCqName(cqName, id);
            }
            InternalCqQuery cqQuery = cqService.getCq(serverCqName);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                String queryStr = null;
                HashSet<String> cqRegionNames = null;
                if (cqQuery != null) {
                    queryStr = cqQuery.getQueryString();
                    cqRegionNames = new HashSet<String>();
                    cqRegionNames.add(cqQuery.getRegionName());
                    authzRequest.closeCQAuthorize(cqName, queryStr, cqRegionNames);
                }
            }
            cqService.closeCq(cqName, id);
            if (cqQuery != null) {
                serverConnection.removeCq(cqName, cqQuery.isDurable());
            }
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
            return;
        }
        catch (Exception e) {
            String err = LocalizedStrings.CloseCQ_EXCEPTION_WHILE_CLOSING_CQ_CQNAME_0.toLocalizedString(new Object[]{cqName});
            this.sendCqResponse(50, err, clientMessage.getTransactionId(), e, serverConnection);
            return;
        }
        this.sendCqResponse(6, LocalizedStrings.CloseCQ_CQ_CLOSED_SUCCESSFULLY.toLocalizedString(), clientMessage.getTransactionId(), null, serverConnection);
        serverConnection.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessCloseCqTime(start - oldStart);
    }
}

