/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.internal.InternalEntity;

public class LuceneDescribeIndexFunction
extends FunctionAdapter
implements InternalEntity {
    public String getId() {
        return LuceneDescribeIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        LuceneIndexDetails result = null;
        Cache cache = context.getCache();
        String serverName = cache.getDistributedSystem().getDistributedMember().getName();
        LuceneIndexInfo indexInfo = (LuceneIndexInfo)context.getArguments();
        LuceneServiceImpl service = (LuceneServiceImpl)LuceneServiceProvider.get((GemFireCache)cache);
        LuceneIndex index = service.getIndex(indexInfo.getIndexName(), indexInfo.getRegionPath());
        LuceneIndexCreationProfile profile = service.getDefinedIndex(indexInfo.getIndexName(), indexInfo.getRegionPath());
        if (index != null) {
            result = new LuceneIndexDetails((LuceneIndexImpl)index, serverName);
        } else if (profile != null) {
            result = new LuceneIndexDetails(profile, serverName);
        }
        context.getResultSender().lastResult(result);
    }
}

