/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;
import org.apache.geode.security.internal.server.Authorizer;
import org.apache.geode.security.internal.server.NoOpAuthorizer;

@Experimental
public class MessageExecutionContext {
    private Cache cache;
    private Locator locator;
    private final Authorizer authorizer;
    private final ProtobufClientStatistics statistics;

    public MessageExecutionContext(Cache cache, Authorizer streamAuthorizer, ProtobufClientStatistics statistics) {
        this.cache = cache;
        this.authorizer = streamAuthorizer;
        this.statistics = statistics;
    }

    public MessageExecutionContext(InternalLocator locator, ProtobufClientStatistics statistics) {
        this.locator = locator;
        this.authorizer = new NoOpAuthorizer();
        this.statistics = statistics;
    }

    public Cache getCache() throws InvalidExecutionContextException {
        if (this.cache != null) {
            return this.cache;
        }
        throw new InvalidExecutionContextException("Operations on the locator should not to try to operate on a cache");
    }

    public Locator getLocator() throws InvalidExecutionContextException {
        if (this.locator != null) {
            return this.locator;
        }
        throw new InvalidExecutionContextException("Operations on the server should not to try to operate on a locator");
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public ProtobufClientStatistics getStatistics() {
        return this.statistics;
    }
}

