/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.IncompatibleVersionException;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolProcessor;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.ProtobufStreamProcessor;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.internal.server.Authenticator;

@Experimental
public final class ProtobufCachePipeline
implements ClientProtocolProcessor {
    private final ProtobufClientStatistics statistics;
    private final Cache cache;
    private final SecurityService securityService;
    private final ProtobufStreamProcessor streamProcessor;
    private final Authenticator authenticator;

    ProtobufCachePipeline(ProtobufStreamProcessor protobufStreamProcessor, ProtobufClientStatistics statistics, Cache cache, Authenticator authenticator, SecurityService securityService) {
        this.streamProcessor = protobufStreamProcessor;
        this.statistics = statistics;
        this.cache = cache;
        this.authenticator = authenticator;
        this.securityService = securityService;
        this.statistics.clientConnected();
    }

    public void processMessage(InputStream inputStream, OutputStream outputStream) throws IOException, IncompatibleVersionException {
        if (!this.authenticator.isAuthenticated()) {
            this.authenticator.authenticate(inputStream, outputStream, this.securityService.getSecurityManager());
        } else {
            this.streamProcessor.receiveMessage(inputStream, outputStream, new MessageExecutionContext(this.cache, this.authenticator.getAuthorizer(), this.statistics));
        }
    }

    public void close() {
        this.statistics.clientDisconnected();
    }
}

