/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.IncompatibleVersionException;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolProcessor;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.ProtobufStreamProcessor;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;

@Experimental
public final class ProtobufLocatorPipeline
implements ClientProtocolProcessor {
    private final ProtobufClientStatistics statistics;
    private final InternalLocator locator;
    private final ProtobufStreamProcessor streamProcessor;

    ProtobufLocatorPipeline(ProtobufStreamProcessor protobufStreamProcessor, ProtobufClientStatistics statistics, InternalLocator locator) {
        this.streamProcessor = protobufStreamProcessor;
        this.statistics = statistics;
        this.locator = locator;
        this.statistics.clientConnected();
    }

    public void processMessage(InputStream inputStream, OutputStream outputStream) throws IOException, IncompatibleVersionException {
        this.streamProcessor.receiveMessage(inputStream, outputStream, new MessageExecutionContext(this.locator, this.statistics));
    }

    public void close() {
        this.statistics.clientDisconnected();
    }
}

