/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol;

import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolProcessor;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolService;
import org.apache.geode.internal.protocol.ProtobufCachePipeline;
import org.apache.geode.internal.protocol.ProtobufLocatorPipeline;
import org.apache.geode.internal.protocol.protobuf.ProtobufStreamProcessor;
import org.apache.geode.internal.protocol.protobuf.statistics.NoOpStatistics;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatisticsImpl;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.internal.server.Authenticator;

public class ProtobufProtocolService
implements ClientProtocolService {
    private volatile ProtobufClientStatistics statistics;
    private final ProtobufStreamProcessor protobufStreamProcessor = new ProtobufStreamProcessor();

    public synchronized void initializeStatistics(String statisticsName, StatisticsFactory factory) {
        this.statistics = new ProtobufClientStatisticsImpl(factory, statisticsName, "ProtobufStats");
    }

    private ProtobufClientStatistics getStatistics() {
        if (this.statistics == null) {
            return new NoOpStatistics();
        }
        return this.statistics;
    }

    public ClientProtocolProcessor createProcessorForCache(Cache cache, Authenticator authenticator, SecurityService securityService) {
        return new ProtobufCachePipeline(this.protobufStreamProcessor, this.getStatistics(), cache, authenticator, securityService);
    }

    public ClientProtocolProcessor createProcessorForLocator(InternalLocator locator) {
        return new ProtobufLocatorPipeline(this.protobufStreamProcessor, this.getStatistics(), locator);
    }
}

