/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf;

import java.util.HashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.serialization.SerializationType;
import org.apache.geode.internal.serialization.exception.UnsupportedEncodingTypeException;
import org.apache.geode.pdx.PdxInstance;

@Experimental
public abstract class EncodingTypeTranslator {
    static final HashMap<Class, BasicTypes.EncodingType> typeToEncodingMap = EncodingTypeTranslator.intializeTypeMap();

    private static HashMap<Class, BasicTypes.EncodingType> intializeTypeMap() {
        HashMap<Class, BasicTypes.EncodingType> result = new HashMap<Class, BasicTypes.EncodingType>();
        result.put(PdxInstance.class, BasicTypes.EncodingType.JSON);
        return result;
    }

    public static SerializationType getSerializationTypeForEncodingType(BasicTypes.EncodingType encodingType) throws UnsupportedEncodingTypeException {
        switch (encodingType) {
            case JSON: {
                return SerializationType.JSON;
            }
        }
        throw new UnsupportedEncodingTypeException("No serialization type found for protobuf encoding type: " + (Object)((Object)encodingType));
    }

    public static BasicTypes.EncodingType getEncodingTypeForObject(Object resultValue) throws UnsupportedEncodingTypeException {
        String pdxClassName;
        if (resultValue instanceof PdxInstance && (pdxClassName = ((PdxInstance)resultValue).getClassName()).equals("__GEMFIRE_JSON")) {
            return BasicTypes.EncodingType.JSON;
        }
        BasicTypes.EncodingType encodingType = typeToEncodingMap.get(resultValue.getClass());
        if (encodingType == null) {
            throw new UnsupportedEncodingTypeException("We cannot translate: " + resultValue.getClass() + " into a specific Protobuf Encoding");
        }
        return encodingType;
    }
}

