/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf;

import java.util.function.Function;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.internal.protocol.protobuf.ClientProtocol;
import org.apache.geode.security.ResourcePermission;

@Experimental
public class OperationContext<OperationRequest, OperationResponse> {
    private final OperationHandler<OperationRequest, OperationResponse> operationHandler;
    private final Function<ClientProtocol.Request, OperationRequest> fromRequest;
    private final Function<OperationResponse, ClientProtocol.Response.Builder> toResponse;
    private final Function<ClientProtocol.ErrorResponse, ClientProtocol.Response.Builder> toErrorResponse;
    private final ResourcePermission accessPermissionRequired;

    public OperationContext(Function<ClientProtocol.Request, OperationRequest> fromRequest, OperationHandler<OperationRequest, OperationResponse> operationHandler, Function<OperationResponse, ClientProtocol.Response.Builder> toResponse, ResourcePermission permissionRequired) {
        this.operationHandler = operationHandler;
        this.fromRequest = fromRequest;
        this.toResponse = toResponse;
        this.toErrorResponse = OperationContext::makeErrorBuilder;
        this.accessPermissionRequired = permissionRequired;
    }

    public static ClientProtocol.Response.Builder makeErrorBuilder(ClientProtocol.ErrorResponse errorResponse) {
        return ClientProtocol.Response.newBuilder().setErrorResponse(errorResponse);
    }

    public OperationHandler<OperationRequest, OperationResponse> getOperationHandler() {
        return this.operationHandler;
    }

    public Function<ClientProtocol.Request, OperationRequest> getFromRequest() {
        return this.fromRequest;
    }

    public Function<OperationResponse, ClientProtocol.Response.Builder> getToResponse() {
        return this.toResponse;
    }

    public Function<ClientProtocol.ErrorResponse, ClientProtocol.Response.Builder> getToErrorResponse() {
        return this.toErrorResponse;
    }

    public ResourcePermission getAccessPermissionRequired() {
        return this.accessPermissionRequired;
    }
}

