/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.protobuf.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.Failure;
import org.apache.geode.internal.protocol.protobuf.OperationContext;
import org.apache.geode.internal.protocol.protobuf.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.Result;
import org.apache.geode.internal.protocol.protobuf.registry.OperationContextRegistry;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.logging.log4j.Logger;

@Experimental
public class ProtobufOpsProcessor {
    private final OperationContextRegistry operationContextRegistry;
    private final SerializationService serializationService;
    private static final Logger logger = LogService.getLogger(ProtobufOpsProcessor.class);

    public ProtobufOpsProcessor(SerializationService serializationService, OperationContextRegistry operationContextRegistry) {
        this.serializationService = serializationService;
        this.operationContextRegistry = operationContextRegistry;
    }

    public ClientProtocol.Response process(ClientProtocol.Request request, MessageExecutionContext context) {
        Result<ClientProtocol.Response.Builder> result;
        ClientProtocol.Request.RequestAPICase requestType = request.getRequestAPICase();
        logger.debug("Processing request of type {}", (Object)requestType);
        OperationContext operationContext = this.operationContextRegistry.getOperationContext(requestType);
        try {
            if (context.getAuthorizer().authorize(operationContext.getAccessPermissionRequired())) {
                result = operationContext.getOperationHandler().process(this.serializationService, operationContext.getFromRequest().apply(request), context);
            } else {
                logger.warn("Received unauthorized request");
                this.recordAuthorizationViolation(context);
                result = Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.AUTHORIZATION_FAILED, "User isn't authorized for this operation."));
            }
        }
        catch (InvalidExecutionContextException exception) {
            logger.error("Invalid execution context found for operation {}", (Object)requestType);
            result = Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.UNSUPPORTED_OPERATION, "Invalid execution context found for operation."));
        }
        ClientProtocol.Response.Builder builder = result.map(operationContext.getToResponse(), operationContext.getToErrorResponse());
        return builder.build();
    }

    private void recordAuthorizationViolation(MessageExecutionContext context) {
        ProtobufClientStatistics statistics = context.getStatistics();
        statistics.incAuthorizationViolations();
    }
}

