/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.EncodingTypeTranslator;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.geode.internal.serialization.SerializationType;
import org.apache.geode.internal.serialization.TypeCodec;
import org.apache.geode.internal.serialization.exception.UnsupportedEncodingTypeException;
import org.apache.geode.internal.serialization.registry.SerializationCodecRegistry;
import org.apache.geode.internal.serialization.registry.exception.CodecNotRegisteredForTypeException;

@Experimental
public class ProtobufSerializationService
implements SerializationService<BasicTypes.EncodingType> {
    private SerializationCodecRegistry serializationCodecRegistry = new SerializationCodecRegistry();

    @Override
    public byte[] encode(BasicTypes.EncodingType encodingTypeValue, Object value) throws UnsupportedEncodingTypeException, CodecNotRegisteredForTypeException {
        TypeCodec codecForType = this.getTypeCodecForProtobufType(encodingTypeValue);
        return codecForType.encode(value);
    }

    @Override
    public Object decode(BasicTypes.EncodingType encodingTypeValue, byte[] value) throws UnsupportedEncodingTypeException, CodecNotRegisteredForTypeException {
        if (encodingTypeValue == BasicTypes.EncodingType.INVALID) {
            return null;
        }
        TypeCodec codecForType = this.getTypeCodecForProtobufType(encodingTypeValue);
        return codecForType.decode(value);
    }

    private TypeCodec getTypeCodecForProtobufType(BasicTypes.EncodingType encodingTypeValue) throws UnsupportedEncodingTypeException, CodecNotRegisteredForTypeException {
        SerializationType serializationTypeForEncodingType = EncodingTypeTranslator.getSerializationTypeForEncodingType(encodingTypeValue);
        return this.serializationCodecRegistry.getCodecForType(serializationTypeForEncodingType);
    }
}

