/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.geode.internal.protocol.protobuf.AuthenticationAPI;
import org.apache.geode.internal.protocol.protobuf.ProtobufSimpleAuthorizer;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.SecurityManager;
import org.apache.geode.security.internal.server.Authenticator;
import org.apache.geode.security.internal.server.Authorizer;

public class ProtobufSimpleAuthenticator
implements Authenticator {
    private ProtobufSimpleAuthorizer authorizer = null;

    public void authenticate(InputStream inputStream, OutputStream outputStream, SecurityManager securityManager) throws IOException {
        AuthenticationAPI.SimpleAuthenticationRequest authenticationRequest = AuthenticationAPI.SimpleAuthenticationRequest.parseDelimitedFrom(inputStream);
        if (authenticationRequest == null) {
            throw new EOFException();
        }
        Properties properties = new Properties();
        properties.setProperty("security-username", authenticationRequest.getUsername());
        properties.setProperty("security-password", authenticationRequest.getPassword());
        this.authorizer = null;
        try {
            Object principal = securityManager.authenticate(properties);
            if (principal != null) {
                this.authorizer = new ProtobufSimpleAuthorizer(principal, securityManager);
            }
        }
        catch (AuthenticationFailedException e) {
            this.authorizer = null;
        }
        AuthenticationAPI.SimpleAuthenticationResponse.newBuilder().setAuthenticated(this.isAuthenticated()).build().writeDelimitedTo(outputStream);
    }

    public boolean isAuthenticated() {
        return this.authorizer != null;
    }

    public Authorizer getAuthorizer() throws AuthenticationRequiredException {
        if (this.authorizer == null) {
            throw new AuthenticationRequiredException("Not yet authenticated");
        }
        return this.authorizer;
    }

    public String implementationID() {
        return "SIMPLE";
    }
}

