/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolMessageHandler;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.exception.InvalidProtocolMessageException;
import org.apache.geode.internal.protocol.protobuf.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.ProtobufOpsProcessor;
import org.apache.geode.internal.protocol.protobuf.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.registry.OperationContextRegistry;
import org.apache.geode.internal.protocol.protobuf.serializer.ProtobufProtocolSerializer;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufUtilities;
import org.apache.logging.log4j.Logger;

@Experimental
public class ProtobufStreamProcessor
implements ClientProtocolMessageHandler {
    private final ProtobufProtocolSerializer protobufProtocolSerializer = new ProtobufProtocolSerializer();
    private final ProtobufOpsProcessor protobufOpsProcessor = new ProtobufOpsProcessor(new ProtobufSerializationService(), new OperationContextRegistry());
    private static final Logger logger = LogService.getLogger();

    @Override
    public void receiveMessage(InputStream inputStream, OutputStream outputStream, MessageExecutionContext executionContext) throws IOException {
        try {
            this.processOneMessage(inputStream, outputStream, executionContext);
        }
        catch (InvalidProtocolMessageException e) {
            throw new IOException(e);
        }
    }

    private void processOneMessage(InputStream inputStream, OutputStream outputStream, MessageExecutionContext executionContext) throws InvalidProtocolMessageException, IOException {
        ClientProtocol.Message message = this.protobufProtocolSerializer.deserialize(inputStream);
        if (message == null) {
            String errorMessage = "Tried to deserialize protobuf message at EOF";
            logger.debug(errorMessage);
            throw new EOFException(errorMessage);
        }
        ProtobufClientStatistics statistics = executionContext.getStatistics();
        statistics.messageReceived(message.getSerializedSize());
        ClientProtocol.Request request = message.getRequest();
        ClientProtocol.Response response = this.protobufOpsProcessor.process(request, executionContext);
        ClientProtocol.MessageHeader responseHeader = ProtobufUtilities.createMessageHeaderForRequest(message);
        ClientProtocol.Message responseMessage = ProtobufUtilities.createProtobufResponse(responseHeader, response);
        statistics.messageSent(responseMessage.getSerializedSize());
        this.protobufProtocolSerializer.serialize(responseMessage, outputStream);
    }
}

