/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.operations;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.LeaseExpiredException;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.Failure;
import org.apache.geode.internal.protocol.protobuf.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.Result;
import org.apache.geode.internal.protocol.protobuf.Success;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufUtilities;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.geode.internal.serialization.exception.UnsupportedEncodingTypeException;
import org.apache.geode.internal.serialization.registry.exception.CodecNotRegisteredForTypeException;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetAllRequestOperationHandler
implements OperationHandler<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.GetAllResponse> process(SerializationService serializationService, RegionAPI.GetAllRequest request, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = executionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received GetAll request for non-existing region {}", (Object)regionName);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.REGION_NOT_FOUND, "Region not found"));
        }
        Map<Boolean, List<Object>> resultsCollection = request.getKeyList().stream().map(key -> this.processOneMessage(serializationService, region, (BasicTypes.EncodedValue)key)).collect(Collectors.partitioningBy(x -> x instanceof BasicTypes.Entry));
        RegionAPI.GetAllResponse.Builder responseBuilder = RegionAPI.GetAllResponse.newBuilder();
        for (Object entry : resultsCollection.get(true)) {
            responseBuilder.addEntries((BasicTypes.Entry)entry);
        }
        for (Object entry : resultsCollection.get(false)) {
            responseBuilder.addFailures((BasicTypes.KeyedError)entry);
        }
        return Success.of(responseBuilder.build());
    }

    private Object processOneMessage(SerializationService serializationService, Region region, BasicTypes.EncodedValue key) {
        try {
            Object decodedKey = ProtobufUtilities.decodeValue(serializationService, key);
            Object value = region.get(decodedKey);
            return ProtobufUtilities.createEntry(serializationService, decodedKey, value);
        }
        catch (UnsupportedEncodingTypeException | CodecNotRegisteredForTypeException ex) {
            logger.error("Encoding not supported: {}", (Throwable)ex);
            return this.createKeyedError(key, "Encoding not supported.", ProtocolErrorCode.VALUE_ENCODING_ERROR);
        }
        catch (TimeoutException | LeaseExpiredException e) {
            logger.error("Operation timed out: {}", e);
            return this.createKeyedError(key, "Operation timed out: " + e.getMessage(), ProtocolErrorCode.OPERATION_TIMEOUT);
        }
        catch (CacheLoaderException | PartitionedRegionStorageException e) {
            logger.error("Data unreachable: {}", e);
            return this.createKeyedError(key, "Data unreachable: " + e.getMessage(), ProtocolErrorCode.DATA_UNREACHABLE);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.error("Invalid input: {}", (Throwable)e);
            return this.createKeyedError(key, "Invalid input: " + e.getMessage(), ProtocolErrorCode.CONSTRAINT_VIOLATION);
        }
    }

    private Object createKeyedError(BasicTypes.EncodedValue key, String errorMessage, ProtocolErrorCode errorCode) {
        return BasicTypes.KeyedError.newBuilder().setKey(key).setError(BasicTypes.Error.newBuilder().setErrorCode(errorCode.codeValue).setMessage(errorMessage)).build();
    }
}

