/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.Result;
import org.apache.geode.internal.protocol.protobuf.ServerAPI;
import org.apache.geode.internal.protocol.protobuf.Success;
import org.apache.geode.internal.serialization.SerializationService;

@Experimental
public class GetAvailableServersOperationHandler
implements OperationHandler<ServerAPI.GetAvailableServersRequest, ServerAPI.GetAvailableServersResponse> {
    @Override
    public Result<ServerAPI.GetAvailableServersResponse> process(SerializationService serializationService, ServerAPI.GetAvailableServersRequest request, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        InternalLocator internalLocator = (InternalLocator)executionContext.getLocator();
        ArrayList serversFromSnapshot = internalLocator.getServerLocatorAdvisee().getLoadSnapshot().getServers(null);
        if (serversFromSnapshot == null) {
            serversFromSnapshot = new ArrayList();
        }
        Collection servers = serversFromSnapshot.stream().map(serverLocation -> this.getServerProtobufMessage((ServerLocation)serverLocation)).collect(Collectors.toList());
        ServerAPI.GetAvailableServersResponse.Builder builder = ServerAPI.GetAvailableServersResponse.newBuilder().addAllServers(servers);
        return Success.of(builder.build());
    }

    private BasicTypes.Server getServerProtobufMessage(ServerLocation serverLocation) {
        BasicTypes.Server.Builder serverBuilder = BasicTypes.Server.newBuilder();
        serverBuilder.setHostname(serverLocation.getHostName()).setPort(serverLocation.getPort());
        return serverBuilder.build();
    }
}

