/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.Failure;
import org.apache.geode.internal.protocol.protobuf.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.Result;
import org.apache.geode.internal.protocol.protobuf.Success;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufUtilities;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetRegionRequestOperationHandler
implements OperationHandler<RegionAPI.GetRegionRequest, RegionAPI.GetRegionResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.GetRegionResponse> process(SerializationService serializationService, RegionAPI.GetRegionRequest request, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = executionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received GetRegion request for non-existing region {}", (Object)regionName);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.REGION_NOT_FOUND, "No region exists for name: " + regionName));
        }
        BasicTypes.Region protoRegion = ProtobufUtilities.createRegionMessageFromRegion(region);
        return Success.of(RegionAPI.GetRegionResponse.newBuilder().setRegion(protoRegion).build());
    }
}

