/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.operations;

import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.Failure;
import org.apache.geode.internal.protocol.protobuf.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.Result;
import org.apache.geode.internal.protocol.protobuf.Success;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufUtilities;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.geode.internal.serialization.exception.UnsupportedEncodingTypeException;
import org.apache.geode.internal.serialization.registry.exception.CodecNotRegisteredForTypeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Experimental
public class PutAllRequestOperationHandler
implements OperationHandler<RegionAPI.PutAllRequest, RegionAPI.PutAllResponse> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Result<RegionAPI.PutAllResponse> process(SerializationService serializationService, RegionAPI.PutAllRequest putAllRequest, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        String regionName = putAllRequest.getRegionName();
        Region region = executionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received PutAll request for non-existing region {}", (Object)regionName);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.REGION_NOT_FOUND, "Region passed does not exist: " + regionName));
        }
        RegionAPI.PutAllResponse.Builder builder = RegionAPI.PutAllResponse.newBuilder().addAllFailedKeys(putAllRequest.getEntryList().stream().map(entry -> this.singlePut(serializationService, region, (BasicTypes.Entry)entry)).filter(Objects::nonNull).collect(Collectors.toList()));
        return Success.of(builder.build());
    }

    private BasicTypes.KeyedError singlePut(SerializationService serializationService, Region region, BasicTypes.Entry entry) {
        try {
            Object decodedValue = ProtobufUtilities.decodeValue(serializationService, entry.getValue());
            Object decodedKey = ProtobufUtilities.decodeValue(serializationService, entry.getKey());
            region.put(decodedKey, decodedValue);
        }
        catch (UnsupportedEncodingTypeException ex) {
            return this.buildAndLogKeyedError(entry, ProtocolErrorCode.VALUE_ENCODING_ERROR, "Encoding not supported", ex);
        }
        catch (CodecNotRegisteredForTypeException ex) {
            return this.buildAndLogKeyedError(entry, ProtocolErrorCode.VALUE_ENCODING_ERROR, "Codec error in protobuf deserialization", ex);
        }
        catch (ClassCastException ex) {
            return this.buildAndLogKeyedError(entry, ProtocolErrorCode.CONSTRAINT_VIOLATION, "Invalid key or value type for region", ex);
        }
        return null;
    }

    private BasicTypes.KeyedError buildAndLogKeyedError(BasicTypes.Entry entry, ProtocolErrorCode errorCode, String message, Exception ex) {
        logger.error(message, (Throwable)ex);
        return BasicTypes.KeyedError.newBuilder().setKey(entry.getKey()).setError(BasicTypes.Error.newBuilder().setErrorCode(errorCode.codeValue).setMessage(message)).build();
    }
}

