/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.Failure;
import org.apache.geode.internal.protocol.protobuf.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.Result;
import org.apache.geode.internal.protocol.protobuf.Success;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufUtilities;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.geode.internal.serialization.exception.UnsupportedEncodingTypeException;
import org.apache.geode.internal.serialization.registry.exception.CodecNotRegisteredForTypeException;
import org.apache.logging.log4j.Logger;

@Experimental
public class PutRequestOperationHandler
implements OperationHandler<RegionAPI.PutRequest, RegionAPI.PutResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.PutResponse> process(SerializationService serializationService, RegionAPI.PutRequest request, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = executionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.warn("Received Put request for non-existing region: {}", (Object)regionName);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.REGION_NOT_FOUND, "Region passed by client did not exist: " + regionName));
        }
        try {
            BasicTypes.Entry entry = request.getEntry();
            Object decodedValue = ProtobufUtilities.decodeValue(serializationService, entry.getValue());
            Object decodedKey = ProtobufUtilities.decodeValue(serializationService, entry.getKey());
            try {
                region.put(decodedKey, decodedValue);
                return Success.of(RegionAPI.PutResponse.newBuilder().build());
            }
            catch (ClassCastException ex) {
                logger.error("Received Put request with invalid key type: {}", (Throwable)ex);
                return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.CONSTRAINT_VIOLATION, "invalid key or value type for region " + regionName));
            }
        }
        catch (UnsupportedEncodingTypeException | CodecNotRegisteredForTypeException ex) {
            logger.error("Got codec error when decoding Put request: {}", (Throwable)ex);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.VALUE_ENCODING_ERROR, ex.getMessage()));
        }
    }
}

