/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.sockets.MessageExecutionContext;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.OperationHandler;
import org.apache.geode.internal.protocol.protobuf.Failure;
import org.apache.geode.internal.protocol.protobuf.ProtocolErrorCode;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.Result;
import org.apache.geode.internal.protocol.protobuf.Success;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufResponseUtilities;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufUtilities;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.geode.internal.serialization.exception.UnsupportedEncodingTypeException;
import org.apache.geode.internal.serialization.registry.exception.CodecNotRegisteredForTypeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Experimental
public class RemoveRequestOperationHandler
implements OperationHandler<RegionAPI.RemoveRequest, RegionAPI.RemoveResponse> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Result<RegionAPI.RemoveResponse> process(SerializationService serializationService, RegionAPI.RemoveRequest request, MessageExecutionContext executionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        Region region = executionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received Remove request for non-existing region {}", (Object)regionName);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.REGION_NOT_FOUND, "Region not found"));
        }
        try {
            Object decodedKey = ProtobufUtilities.decodeValue(serializationService, request.getKey());
            region.remove(decodedKey);
            return Success.of(RegionAPI.RemoveResponse.newBuilder().build());
        }
        catch (UnsupportedEncodingTypeException ex) {
            logger.error("Received Remove request with unsupported encoding: {}", (Throwable)ex);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.VALUE_ENCODING_ERROR, "Encoding not supported: " + ex.getMessage()));
        }
        catch (CodecNotRegisteredForTypeException ex) {
            logger.error("Got codec error when decoding Remove request: {}", (Throwable)ex);
            return Failure.of(ProtobufResponseUtilities.makeErrorResponse(ProtocolErrorCode.VALUE_ENCODING_ERROR, "Codec error in protobuf deserialization: " + ex.getMessage()));
        }
    }
}

