/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.OperationContext;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.ServerAPI;
import org.apache.geode.internal.protocol.protobuf.operations.GetAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.operations.GetAvailableServersOperationHandler;
import org.apache.geode.internal.protocol.protobuf.operations.GetRegionNamesRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.operations.GetRegionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.operations.GetRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.operations.PutAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.operations.PutRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.operations.RemoveRequestOperationHandler;
import org.apache.geode.security.ResourcePermission;

@Experimental
public class OperationContextRegistry {
    private Map<ClientProtocol.Request.RequestAPICase, OperationContext> operationContexts = new ConcurrentHashMap<ClientProtocol.Request.RequestAPICase, OperationContext>();

    public OperationContextRegistry() {
        this.addContexts();
    }

    public OperationContext getOperationContext(ClientProtocol.Request.RequestAPICase apiCase) {
        return this.operationContexts.get((Object)apiCase);
    }

    private void addContexts() {
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETREQUEST, new OperationContext<RegionAPI.GetRequest, RegionAPI.GetResponse>(ClientProtocol.Request::getGetRequest, new GetRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetResponse((RegionAPI.GetResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETALLREQUEST, new OperationContext<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse>(ClientProtocol.Request::getGetAllRequest, new GetAllRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetAllResponse((RegionAPI.GetAllResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.PUTREQUEST, new OperationContext<RegionAPI.PutRequest, RegionAPI.PutResponse>(ClientProtocol.Request::getPutRequest, new PutRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setPutResponse((RegionAPI.PutResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.PUTALLREQUEST, new OperationContext<RegionAPI.PutAllRequest, RegionAPI.PutAllResponse>(ClientProtocol.Request::getPutAllRequest, new PutAllRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setPutAllResponse((RegionAPI.PutAllResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.REMOVEREQUEST, new OperationContext<RegionAPI.RemoveRequest, RegionAPI.RemoveResponse>(ClientProtocol.Request::getRemoveRequest, new RemoveRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setRemoveResponse((RegionAPI.RemoveResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETREGIONNAMESREQUEST, new OperationContext<RegionAPI.GetRegionNamesRequest, RegionAPI.GetRegionNamesResponse>(ClientProtocol.Request::getGetRegionNamesRequest, new GetRegionNamesRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetRegionNamesResponse((RegionAPI.GetRegionNamesResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETREGIONREQUEST, new OperationContext<RegionAPI.GetRegionRequest, RegionAPI.GetRegionResponse>(ClientProtocol.Request::getGetRegionRequest, new GetRegionRequestOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetRegionResponse((RegionAPI.GetRegionResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Request.RequestAPICase.GETAVAILABLESERVERSREQUEST, new OperationContext<ServerAPI.GetAvailableServersRequest, ServerAPI.GetAvailableServersResponse>(ClientProtocol.Request::getGetAvailableServersRequest, new GetAvailableServersOperationHandler(), opsResp -> ClientProtocol.Response.newBuilder().setGetAvailableServersResponse((ServerAPI.GetAvailableServersResponse)opsResp), new ResourcePermission(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ)));
    }
}

