/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.statistics;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;

public class ProtobufClientStatisticsImpl
implements ProtobufClientStatistics {
    private final StatisticsType statType;
    private final Statistics stats;
    private final int currentClientConnectionsId;
    private final int clientConnectionTerminationsId;
    private final int clientConnectionStartsId;
    private final int bytesReceivedId;
    private final int bytesSentId;
    private final int messagesReceivedId;
    private final int messagesSentId;
    private final int authorizationViolationsId;
    private final int authenticationFailuresId;

    public ProtobufClientStatisticsImpl(StatisticsFactory statisticsFactory, String statisticsName, String typeName) {
        StatisticDescriptor[] serverStatDescriptors = new StatisticDescriptor[]{statisticsFactory.createIntGauge("currentClientConnections", "Number of sockets accepted and used for client to server messaging.", "sockets"), statisticsFactory.createIntCounter("clientConnectionStarts", "Number of sockets accepted and used for client to server messaging.", "sockets"), statisticsFactory.createIntCounter("clientConnectionTerminations", "Number of sockets that were used for client to server messaging.", "sockets"), statisticsFactory.createLongCounter("authenticationFailures", "Authentication failures", "attemptss"), statisticsFactory.createLongCounter("authorizationViolations", "Operations not allowed to proceed", "operations"), statisticsFactory.createLongCounter("bytesReceived", "Bytes received from client messaging.", "bytes"), statisticsFactory.createLongCounter("bytesSent", "Bytes sent for client messaging.", "bytes"), statisticsFactory.createLongCounter("messagesReceived", "Messages received from clients.", "messages"), statisticsFactory.createLongCounter("messagesSent", "Messages sent to clients.", "messages")};
        this.statType = statisticsFactory.createType(typeName, "Protobuf client/server statistics", serverStatDescriptors);
        this.stats = statisticsFactory.createAtomicStatistics(this.statType, statisticsName);
        this.currentClientConnectionsId = this.stats.nameToId("currentClientConnections");
        this.clientConnectionStartsId = this.stats.nameToId("clientConnectionStarts");
        this.clientConnectionTerminationsId = this.stats.nameToId("clientConnectionTerminations");
        this.authorizationViolationsId = this.stats.nameToId("authorizationViolations");
        this.authenticationFailuresId = this.stats.nameToId("authenticationFailures");
        this.bytesReceivedId = this.stats.nameToId("bytesReceived");
        this.bytesSentId = this.stats.nameToId("bytesSent");
        this.messagesReceivedId = this.stats.nameToId("messagesReceived");
        this.messagesSentId = this.stats.nameToId("messagesSent");
    }

    @Override
    public void clientConnected() {
        this.stats.incInt(this.currentClientConnectionsId, 1);
        this.stats.incInt(this.clientConnectionStartsId, 1);
    }

    @Override
    public void clientDisconnected() {
        this.stats.incInt(this.currentClientConnectionsId, -1);
        this.stats.incInt(this.clientConnectionTerminationsId, 1);
    }

    @Override
    public void messageReceived(int bytes) {
        this.stats.incLong(this.bytesReceivedId, (long)bytes);
        this.stats.incLong(this.messagesReceivedId, 1L);
    }

    @Override
    public void messageSent(int bytes) {
        this.stats.incLong(this.bytesSentId, (long)bytes);
        this.stats.incLong(this.messagesSentId, 1L);
    }

    @Override
    public void incAuthorizationViolations() {
        this.stats.incLong(this.authorizationViolationsId, 1L);
    }

    @Override
    public void incAuthenticationFailures() {
        this.stats.incLong(this.authenticationFailuresId, 1L);
    }
}

