/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.utilities;

import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.ServerAPI;

@Experimental
public abstract class ProtobufRequestUtilities {
    public static ClientProtocol.Request createGetRequest(String regionName, BasicTypes.EncodedValue key) {
        RegionAPI.GetRequest getRequest = RegionAPI.GetRequest.newBuilder().setRegionName(regionName).setKey(key).build();
        return ClientProtocol.Request.newBuilder().setGetRequest(getRequest).build();
    }

    public static ClientProtocol.Request createRemoveRequest(String regionName, BasicTypes.EncodedValue key) {
        RegionAPI.RemoveRequest removeRequest = RegionAPI.RemoveRequest.newBuilder().setRegionName(regionName).setKey(key).build();
        return ClientProtocol.Request.newBuilder().setRemoveRequest(removeRequest).build();
    }

    public static RegionAPI.GetRegionNamesRequest createGetRegionNamesRequest() {
        return RegionAPI.GetRegionNamesRequest.newBuilder().build();
    }

    public static ClientProtocol.Request createPutRequest(String region, BasicTypes.Entry entry) {
        RegionAPI.PutRequest putRequest = RegionAPI.PutRequest.newBuilder().setRegionName(region).setEntry(entry).build();
        return ClientProtocol.Request.newBuilder().setPutRequest(putRequest).build();
    }

    public static RegionAPI.GetAllRequest createGetAllRequest(String regionName, Set<BasicTypes.EncodedValue> keys) {
        RegionAPI.GetAllRequest.Builder getAllRequestBuilder = RegionAPI.GetAllRequest.newBuilder().setRegionName(regionName);
        getAllRequestBuilder.addAllKey(keys);
        return getAllRequestBuilder.build();
    }

    public static ClientProtocol.Request createPutAllRequest(String regionName, Set<BasicTypes.Entry> entries) {
        RegionAPI.PutAllRequest.Builder putAllRequestBuilder = RegionAPI.PutAllRequest.newBuilder().setRegionName(regionName);
        putAllRequestBuilder.addAllEntry(entries);
        return ClientProtocol.Request.newBuilder().setPutAllRequest(putAllRequestBuilder).build();
    }

    public static ServerAPI.GetAvailableServersRequest createGetAvailableServersRequest() {
        ServerAPI.GetAvailableServersRequest.Builder builder = ServerAPI.GetAvailableServersRequest.newBuilder();
        return builder.build();
    }
}

