/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.utilities;

import com.google.protobuf.ByteString;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.internal.protocol.protobuf.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.EncodingTypeTranslator;
import org.apache.geode.internal.protocol.protobuf.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.utilities.ProtobufPrimitiveTypes;
import org.apache.geode.internal.protocol.protobuf.utilities.exception.UnknownProtobufPrimitiveType;
import org.apache.geode.internal.serialization.SerializationService;
import org.apache.geode.internal.serialization.exception.UnsupportedEncodingTypeException;
import org.apache.geode.internal.serialization.registry.exception.CodecNotRegisteredForTypeException;

@Experimental
public abstract class ProtobufUtilities {
    public static BasicTypes.EncodedValue createEncodedValue(SerializationService serializationService, Object unencodedValue) throws UnsupportedEncodingTypeException, CodecNotRegisteredForTypeException {
        try {
            return ProtobufUtilities.createPrimitiveEncodedValue(unencodedValue);
        }
        catch (UnknownProtobufPrimitiveType e) {
            BasicTypes.EncodingType resultEncodingType = EncodingTypeTranslator.getEncodingTypeForObject(unencodedValue);
            byte[] encodedValue = serializationService.encode(resultEncodingType, unencodedValue);
            BasicTypes.CustomEncodedValue.Builder customEncodedValueBuilder = BasicTypes.CustomEncodedValue.newBuilder().setEncodingType(resultEncodingType).setValue(ByteString.copyFrom((byte[])encodedValue));
            return BasicTypes.EncodedValue.newBuilder().setCustomEncodedValue(customEncodedValueBuilder).build();
        }
    }

    public static BasicTypes.Entry createEntry(BasicTypes.EncodedValue key, BasicTypes.EncodedValue value) {
        return BasicTypes.Entry.newBuilder().setKey(key).setValue(value).build();
    }

    public static BasicTypes.Entry createEntry(SerializationService serializationService, Object unencodedKey, Object unencodedValue) throws UnsupportedEncodingTypeException, CodecNotRegisteredForTypeException {
        if (unencodedValue == null) {
            return BasicTypes.Entry.newBuilder().setKey(ProtobufUtilities.createEncodedValue(serializationService, unencodedKey)).build();
        }
        return ProtobufUtilities.createEntry(ProtobufUtilities.createEncodedValue(serializationService, unencodedKey), ProtobufUtilities.createEncodedValue(serializationService, unencodedValue));
    }

    public static ClientProtocol.Message createProtobufResponse(ClientProtocol.MessageHeader messageHeader, ClientProtocol.Response response) {
        return ClientProtocol.Message.newBuilder().setMessageHeader(messageHeader).setResponse(response).build();
    }

    public static ClientProtocol.Message createProtobufMessage(ClientProtocol.MessageHeader messageHeader, ClientProtocol.Request request) {
        return ClientProtocol.Message.newBuilder().setMessageHeader(messageHeader).setRequest(request).build();
    }

    public static ClientProtocol.Request createProtobufRequestWithGetAllRequest(RegionAPI.GetAllRequest getAllRequest) {
        return ClientProtocol.Request.newBuilder().setGetAllRequest(getAllRequest).build();
    }

    public static ClientProtocol.MessageHeader createMessageHeaderForRequest(ClientProtocol.Message request) {
        return ProtobufUtilities.createMessageHeader(request.getMessageHeader().getCorrelationId());
    }

    public static ClientProtocol.MessageHeader createMessageHeader(int correlationId) {
        return ClientProtocol.MessageHeader.newBuilder().setCorrelationId(correlationId).build();
    }

    public static Object decodeValue(SerializationService serializationService, BasicTypes.EncodedValue encodedValue) throws UnsupportedEncodingTypeException, CodecNotRegisteredForTypeException {
        if (encodedValue.getValueCase() == BasicTypes.EncodedValue.ValueCase.CUSTOMENCODEDVALUE) {
            BasicTypes.CustomEncodedValue customEncodedValue = encodedValue.getCustomEncodedValue();
            return serializationService.decode(customEncodedValue.getEncodingType(), customEncodedValue.getValue().toByteArray());
        }
        try {
            return ProtobufUtilities.getPrimitiveValueFromEncodedValue(encodedValue);
        }
        catch (UnknownProtobufPrimitiveType unknownProtobufPrimitiveType) {
            throw new UnsupportedEncodingTypeException("Unknown primitive type encoding", unknownProtobufPrimitiveType);
        }
    }

    public static BasicTypes.Region createRegionMessageFromRegion(Region region) {
        RegionAttributes regionAttributes = region.getAttributes();
        BasicTypes.Region.Builder protoRegionBuilder = BasicTypes.Region.newBuilder();
        protoRegionBuilder.setName(region.getName());
        protoRegionBuilder.setSize(region.size());
        protoRegionBuilder.setPersisted(regionAttributes.getDataPolicy().withPersistence());
        if (regionAttributes.getKeyConstraint() != null) {
            protoRegionBuilder.setKeyConstraint(regionAttributes.getKeyConstraint().toString());
        }
        if (regionAttributes.getValueConstraint() != null) {
            protoRegionBuilder.setValueConstraint(regionAttributes.getValueConstraint().toString());
        }
        protoRegionBuilder.setScope(regionAttributes.getScope().toString());
        protoRegionBuilder.setDataPolicy(regionAttributes.getDataPolicy().toString());
        return protoRegionBuilder.build();
    }

    public static ClientProtocol.Request createProtobufRequestWithGetRegionNamesRequest(RegionAPI.GetRegionNamesRequest getRegionNamesRequest) {
        return ClientProtocol.Request.newBuilder().setGetRegionNamesRequest(getRegionNamesRequest).build();
    }

    public static ClientProtocol.Request.Builder createProtobufRequestBuilder() {
        return ClientProtocol.Request.newBuilder();
    }

    static BasicTypes.EncodedValue createPrimitiveEncodedValue(Object valueToEncode) throws UnknownProtobufPrimitiveType {
        ProtobufPrimitiveTypes protobufPrimitiveTypes = ProtobufPrimitiveTypes.valueOf(valueToEncode.getClass());
        BasicTypes.EncodedValue.Builder builder = BasicTypes.EncodedValue.newBuilder();
        switch (protobufPrimitiveTypes) {
            case INT: {
                builder.setIntResult((Integer)valueToEncode);
                break;
            }
            case LONG: {
                builder.setLongResult((Long)valueToEncode);
                break;
            }
            case SHORT: {
                builder.setShortResult(((Short)valueToEncode).shortValue());
                break;
            }
            case BYTE: {
                builder.setByteResult(((Byte)valueToEncode).byteValue());
                break;
            }
            case DOUBLE: {
                builder.setDoubleResult((Double)valueToEncode);
                break;
            }
            case FLOAT: {
                builder.setFloatResult(((Float)valueToEncode).floatValue());
                break;
            }
            case BINARY: {
                builder.setBinaryResult(ByteString.copyFrom((byte[])((byte[])valueToEncode)));
                break;
            }
            case BOOLEAN: {
                builder.setBooleanResult((Boolean)valueToEncode);
                break;
            }
            case STRING: {
                builder.setStringResult((String)valueToEncode);
            }
        }
        return builder.build();
    }

    static Object getPrimitiveValueFromEncodedValue(BasicTypes.EncodedValue encodedValue) throws UnknownProtobufPrimitiveType {
        switch (encodedValue.getValueCase()) {
            case BINARYRESULT: {
                return encodedValue.getBinaryResult().toByteArray();
            }
            case BOOLEANRESULT: {
                return encodedValue.getBooleanResult();
            }
            case BYTERESULT: {
                return (byte)encodedValue.getByteResult();
            }
            case DOUBLERESULT: {
                return encodedValue.getDoubleResult();
            }
            case FLOATRESULT: {
                return Float.valueOf(encodedValue.getFloatResult());
            }
            case INTRESULT: {
                return encodedValue.getIntResult();
            }
            case LONGRESULT: {
                return encodedValue.getLongResult();
            }
            case SHORTRESULT: {
                return (short)encodedValue.getShortResult();
            }
            case STRINGRESULT: {
                return encodedValue.getStringResult();
            }
        }
        throw new UnknownProtobufPrimitiveType("Unknown primitive type for: " + (Object)((Object)encodedValue.getValueCase()));
    }
}

