/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.registry;

import java.util.HashMap;
import java.util.ServiceLoader;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.serialization.SerializationType;
import org.apache.geode.internal.serialization.TypeCodec;
import org.apache.geode.internal.serialization.registry.exception.CodecAlreadyRegisteredForTypeException;
import org.apache.geode.internal.serialization.registry.exception.CodecNotRegisteredForTypeException;

@Experimental
public class SerializationCodecRegistry {
    private final HashMap<SerializationType, TypeCodec> codecRegistry = new HashMap();

    public SerializationCodecRegistry() {
        ServiceLoader<TypeCodec> typeCodecs = ServiceLoader.load(TypeCodec.class);
        try {
            for (TypeCodec typeCodec : typeCodecs) {
                this.register(typeCodec.getSerializationType(), typeCodec);
            }
        }
        catch (CodecAlreadyRegisteredForTypeException ex) {
            throw new GemFireConfigException("Multiple implementations found for the same TypeCodec", (Throwable)ex);
        }
    }

    private void register(SerializationType serializationType, TypeCodec<?> typeCodec) {
        if (this.codecRegistry.containsKey((Object)serializationType)) {
            throw new CodecAlreadyRegisteredForTypeException("There is already a codec registered for type: " + (Object)((Object)serializationType));
        }
        this.codecRegistry.put(serializationType, typeCodec);
    }

    public int getRegisteredCodecCount() {
        return this.codecRegistry.size();
    }

    public TypeCodec getCodecForType(SerializationType serializationType) throws CodecNotRegisteredForTypeException {
        TypeCodec typeCodec = this.codecRegistry.get((Object)serializationType);
        if (typeCodec == null) {
            throw new CodecNotRegisteredForTypeException("There is no codec registered for type: " + (Object)((Object)serializationType));
        }
        return typeCodec;
    }

    public void shutdown() {
        this.codecRegistry.clear();
    }
}

