/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.apache.geode.management.internal.web.domain.QueryParameterSource;
import org.apache.geode.management.internal.web.util.ConvertUtils;
import org.apache.geode.management.internal.web.util.UriUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller(value="shellController")
@RequestMapping(value={"/v1"})
public class ShellCommandsController
extends AbstractCommandsController {
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/management/commands"})
    public ResponseEntity<InputStreamResource> command(@RequestParam(value="cmd") String command, @RequestParam(value="resources", required=false) MultipartFile[] fileResource) throws IOException {
        String result = this.processCommand(UriUtils.decode(command), this.getEnvironment(), ConvertUtils.convert(fileResource));
        return this.getResponse(result);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/mbean/attribute"})
    public ResponseEntity<?> getAttribute(@RequestParam(value="resourceName") String resourceName, @RequestParam(value="attributeName") String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException, MalformedObjectNameException {
        MBeanServer mBeanServer = this.getMBeanServer();
        ObjectName objectName = ObjectName.getInstance(UriUtils.decode(resourceName));
        Object attributeValue = mBeanServer.getAttribute(objectName, UriUtils.decode(attributeName));
        byte[] serializedResult = org.apache.geode.internal.util.IOUtils.serializeObject((Object)attributeValue);
        return new ResponseEntity((Object)serializedResult, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/mbean/operation"})
    public ResponseEntity<?> invoke(@RequestParam(value="resourceName") String resourceName, @RequestParam(value="operationName") String operationName, @RequestParam(value="signature", required=false) String[] signature, @RequestParam(value="parameters", required=false) Object[] parameters) throws MalformedObjectNameException, MBeanException, InstanceNotFoundException, ReflectionException, IOException {
        signature = signature != null ? signature : ArrayUtils.EMPTY_STRING_ARRAY;
        parameters = parameters != null ? parameters : ObjectUtils.EMPTY_OBJECT_ARRAY;
        MBeanServer mBeanServer = this.getMBeanServer();
        ObjectName objectName = ObjectName.getInstance(UriUtils.decode(resourceName));
        Object result = mBeanServer.invoke(objectName, UriUtils.decode(operationName), parameters, signature);
        byte[] serializedResult = org.apache.geode.internal.util.IOUtils.serializeObject((Object)result);
        return new ResponseEntity((Object)serializedResult, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/mbean/query"})
    public ResponseEntity<?> queryNames(@RequestBody QueryParameterSource query) throws IOException {
        Set<ObjectName> objectNames = this.getMBeanServer().queryNames(query.getObjectName(), query.getQueryExpression());
        return new ResponseEntity((Object)org.apache.geode.internal.util.IOUtils.serializeObject(objectNames), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, value={"/ping"})
    public ResponseEntity<String> ping() {
        return new ResponseEntity((Object)"pong", HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/version"})
    @ResponseBody
    public String version() {
        return GemFireVersion.getProductName().concat("/").concat(GemFireVersion.getGemFireVersion());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/version/full"})
    @ResponseBody
    public String fullVersion() {
        return GemFireVersion.asString();
    }

    private ResponseEntity<InputStreamResource> getResponse(String result) {
        CommandResult commandResult = ResultBuilder.fromJson((String)result);
        if (commandResult.getStatus().equals((Object)Result.Status.OK) && commandResult.hasFileToDownload()) {
            return this.getFileDownloadResponse(commandResult);
        }
        return this.getJsonResponse(result);
    }

    private ResponseEntity<InputStreamResource> getJsonResponse(String result) {
        HttpHeaders respHeaders = new HttpHeaders();
        try {
            InputStreamResource isr = new InputStreamResource(IOUtils.toInputStream((String)result, (String)"UTF-8"));
            respHeaders.set("Content-Type", "application/json");
            return new ResponseEntity((Object)isr, (MultiValueMap)respHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException("IO Error writing file to output stream", e);
        }
    }

    private ResponseEntity<InputStreamResource> getFileDownloadResponse(CommandResult commandResult) {
        HttpHeaders respHeaders = new HttpHeaders();
        Path filePath = commandResult.getFileToDownload();
        try {
            InputStreamResource isr = new InputStreamResource((InputStream)new FileInputStream(filePath.toFile()));
            respHeaders.set("Content-Type", "application/octet-stream");
            ResponseEntity responseEntity = new ResponseEntity((Object)isr, (MultiValueMap)respHeaders, HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            throw new RuntimeException("IO Error writing file to output stream", e);
        }
        finally {
            FileUtils.deleteQuietly((File)filePath.toFile());
        }
    }
}

