/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.http.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.util.IOUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StreamUtils;

public class SerializableObjectHttpMessageConverter
extends AbstractHttpMessageConverter<Serializable> {
    public SerializableObjectHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL});
    }

    protected boolean supports(Class<?> type) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("%1$s.supports(%2$s)", ((Object)((Object)this)).getClass().getName(), type.getName()), new Throwable());
        }
        return type != null && Serializable.class.isAssignableFrom(type);
    }

    protected Serializable readInternal(Class<? extends Serializable> type, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try {
            return type.cast(IOUtils.deserializeObject((byte[])IOUtils.toByteArray((InputStream)inputMessage.getBody()), (ClassLoader)((ClassLoader)ObjectUtils.defaultIfNull((Object[])new ClassLoader[]{type.getClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()}))));
        }
        catch (ClassNotFoundException e) {
            throw new HttpMessageNotReadableException(String.format("Unable to convert the HTTP message body into an Object of type (%1$s)", type.getName()), (Throwable)e);
        }
    }

    protected void setContentLength(HttpMessage message, byte[] messageBody) {
        message.getHeaders().setContentLength((long)messageBody.length);
    }

    protected void writeInternal(Serializable serializableObject, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        byte[] messageBody = IOUtils.serializeObject((Object)serializableObject);
        this.setContentLength((HttpMessage)outputMessage, messageBody);
        StreamUtils.copy((byte[])messageBody, (OutputStream)outputMessage.getBody());
    }
}

