/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.FastManifestParser;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class JarUtils {
    public static boolean isJar(String path) {
        int len = path.length();
        return path.regionMatches(true, len - 4, ".jar", 0, 4) || path.regionMatches(true, len - 4, ".zip", 0, 4) || path.regionMatches(true, len - 4, ".war", 0, 4) || path.regionMatches(true, len - 4, ".car", 0, 4) || path.regionMatches(true, len - 6, ".wsjar", 0, 6);
    }

    public static String leafName(String path) {
        int maxIdx;
        int lastSlashIdx = File.separatorChar == '/' ? path.lastIndexOf(47) : Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar));
        int sepIdx = path.indexOf("---");
        if (sepIdx >= 0) {
            sepIdx += "---".length() - 1;
        }
        return (maxIdx = Math.max(lastSlashIdx, sepIdx)) < 0 ? path : path.substring(maxIdx + 1);
    }

    public static boolean isJREJar(File file, int ancestralScanDepth, Set<String> knownJREPaths, Set<String> knownNonJREPaths, Set<String> knownRtJarPaths, LogNode log) {
        if (ancestralScanDepth == 0) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        String parentPathStr = parent.getPath();
        if (knownJREPaths.contains(parentPathStr)) {
            return true;
        }
        if (knownNonJREPaths.contains(parentPathStr)) {
            return false;
        }
        File rt = new File(parent, File.separatorChar == '/' ? "jre/lib/rt.jar" : String.format("jre%clib%crt.jar", Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar)));
        boolean rtExists = rt.exists();
        if (!rtExists && !(rtExists = (rt = new File(parent, File.separatorChar == '/' ? "lib/rt.jar" : String.format("lib%crt.jar", Character.valueOf(File.separatorChar)))).exists())) {
            rt = new File(parent, "rt.jar");
            rtExists = rt.exists();
        }
        boolean isJREJar = false;
        if (rtExists && rt.isFile()) {
            FastManifestParser manifest = new FastManifestParser(rt, log);
            if (manifest.isSystemJar) {
                try {
                    File rtCanonical = rt.getCanonicalFile();
                    knownRtJarPaths.add(rt.getPath());
                    isJREJar = true;
                    File rtCanonicalParent = rtCanonical.getParentFile();
                    if (rtCanonicalParent != null) {
                        File rtCanonicalGrandParent;
                        knownJREPaths.add(rtCanonicalParent.getPath());
                        if (rtCanonicalParent.getName().equals("lib") && (rtCanonicalGrandParent = rtCanonicalParent.getParentFile()) != null) {
                            knownJREPaths.add(rtCanonicalGrandParent.getPath());
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (!isJREJar) {
            isJREJar = JarUtils.isJREJar(parent, ancestralScanDepth - 1, knownJREPaths, knownNonJREPaths, knownRtJarPaths, log);
        }
        if (!isJREJar) {
            knownNonJREPaths.add(parentPathStr);
        } else {
            knownJREPaths.add(parentPathStr);
        }
        return isJREJar;
    }
}

