/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.net.InetAddress;
import java.util.Properties;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.admin.DistributionLocator;
import org.apache.geode.admin.DistributionLocatorConfig;
import org.apache.geode.admin.internal.InetAddressUtil;
import org.apache.geode.admin.internal.ManagedEntityConfigImpl;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DistributionLocatorConfigImpl
extends ManagedEntityConfigImpl
implements DistributionLocatorConfig {
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    private int port = 0;
    private String bindAddress = null;
    private Properties dsProperties = new Properties();
    private DistributionLocator locator = null;

    static DistributionLocatorConfig createConfigFor(String host, int port, InetAddress bindAddress) {
        String[] info = new String[]{"unknown", "unknown"};
        try {
            TcpClient client = new TcpClient();
            info = bindAddress != null ? client.getInfo(bindAddress, port) : client.getInfo(InetAddressUtil.toInetAddress(host), port);
            if (info == null) {
                return null;
            }
        }
        catch (GemFireConfigException client) {
            // empty catch block
        }
        DistributionLocatorConfigImpl config = new DistributionLocatorConfigImpl();
        config.setHost(host);
        config.setPort(port);
        if (bindAddress != null) {
            config.setBindAddress(bindAddress.getHostAddress());
        }
        config.setWorkingDirectory(info[0]);
        config.setProductDirectory(info[1]);
        return config;
    }

    public DistributionLocatorConfigImpl() {
        this.dsProperties.setProperty("mcast-port", "0");
    }

    void setLocator(DistributionLocator locator) {
        this.locator = locator;
    }

    @Override
    protected boolean isReadOnly() {
        return this.locator != null && this.locator.isRunning();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.checkReadOnly();
        this.port = port;
        this.configChanged();
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void setBindAddress(String bindAddress) {
        this.checkReadOnly();
        this.bindAddress = bindAddress;
        this.configChanged();
    }

    @Override
    public void setDistributedSystemProperties(Properties props) {
        this.dsProperties = props;
    }

    @Override
    public Properties getDistributedSystemProperties() {
        return this.dsProperties;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.port < 0 || this.port > 65535) {
            throw new IllegalArgumentException(LocalizedStrings.DistributionLocatorConfigImpl_PORT_0_MUST_BE_AN_INTEGER_BETWEEN_1_AND_2.toLocalizedString(this.port, 0, 65535));
        }
        if (this.bindAddress != null && InetAddressUtil.validateHost(this.bindAddress) == null) {
            throw new IllegalArgumentException(LocalizedStrings.DistributionLocatorConfigImpl_INVALID_HOST_0.toLocalizedString(this.bindAddress));
        }
    }

    @Override
    protected void configChanged() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DistributionLocatorConfigImpl clone = (DistributionLocatorConfigImpl)super.clone();
        clone.locator = null;
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DistributionLocatorConfig: host=").append(this.getHost());
        sb.append(", bindAddress=").append(this.getBindAddress());
        sb.append(", port=").append(this.getPort());
        return sb.toString();
    }
}

