/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.admin.internal.FlushToDiskResponse;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class FlushToDiskRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();

    public static void send(DM dm, Set recipients) {
        FlushToDiskRequest request = new FlushToDiskRequest();
        request.setRecipients(recipients);
        FlushToDiskProcessor replyProcessor = new FlushToDiskProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            logger.debug((Object)e);
        }
        AdminResponse response = request.createResponse((DistributionManager)dm);
        response.setSender(dm.getDistributionManagerId());
        replyProcessor.process(response);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        InternalCache cache = dm.getCache();
        if (cache != null) {
            cache.listDiskStoresIncludingRegionOwned().forEach(DiskStore::flush);
        }
        return new FlushToDiskResponse(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 2126;
    }

    private static class FlushToDiskProcessor
    extends AdminMultipleReplyProcessor {
        public FlushToDiskProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }
    }
}

