/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.client.NoAvailableLocatorsException;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallback;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ClientReplacementRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersRequest;
import org.apache.geode.cache.client.internal.locator.GetAllServersResponse;
import org.apache.geode.cache.client.internal.locator.LocatorListRequest;
import org.apache.geode.cache.client.internal.locator.LocatorListResponse;
import org.apache.geode.cache.client.internal.locator.QueueConnectionRequest;
import org.apache.geode.cache.client.internal.locator.QueueConnectionResponse;
import org.apache.geode.cache.client.internal.locator.ServerLocationRequest;
import org.apache.geode.cache.client.internal.locator.ServerLocationResponse;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.gms.membership.HostAddress;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class AutoConnectionSourceImpl
implements ConnectionSource {
    private static final Logger logger = LogService.getLogger();
    private TcpClient tcpClient;
    protected static final LocatorListRequest LOCATOR_LIST_REQUEST = new LocatorListRequest();
    private static final Comparator<HostAddress> SOCKET_ADDRESS_COMPARATOR = new Comparator<HostAddress>(){

        @Override
        public int compare(HostAddress address, HostAddress otherAddress) {
            InetSocketAddress inetSocketAddress = address.getSocketInetAddress();
            InetSocketAddress otherInetSocketAddress = otherAddress.getSocketInetAddress();
            if (inetSocketAddress.getAddress() == null || otherInetSocketAddress.getAddress() == null) {
                return 0;
            }
            int result = inetSocketAddress.getAddress().getCanonicalHostName().compareTo(otherInetSocketAddress.getAddress().getCanonicalHostName());
            if (result != 0) {
                return result;
            }
            return inetSocketAddress.getPort() - otherInetSocketAddress.getPort();
        }
    };
    protected final List<HostAddress> initialLocators;
    private final String serverGroup;
    private AtomicReference<LocatorList> locators = new AtomicReference();
    private AtomicReference<LocatorList> onlineLocators = new AtomicReference();
    protected InternalPool pool;
    private final int connectionTimeout;
    private long locatorUpdateInterval;
    private volatile LocatorDiscoveryCallback locatorCallback = new LocatorDiscoveryCallbackAdapter();
    private volatile boolean isBalanced = true;
    private final Map<InetSocketAddress, Exception> locatorState = new HashMap<InetSocketAddress, Exception>();

    public AutoConnectionSourceImpl(List<InetSocketAddress> locators, List<HostAddress> contacts, String serverGroup, int handshakeTimeout) {
        ArrayList<HostAddress> tmpContacts = new ArrayList<HostAddress>(Collections.unmodifiableList(contacts));
        this.locators.set(new LocatorList(tmpContacts));
        this.onlineLocators.set(new LocatorList(Collections.emptyList()));
        this.initialLocators = Collections.unmodifiableList(this.locators.get().getLocatorAddresses());
        this.connectionTimeout = handshakeTimeout;
        this.serverGroup = serverGroup;
        this.tcpClient = new TcpClient();
    }

    @Override
    public boolean isBalanced() {
        return this.isBalanced;
    }

    @Override
    public List<ServerLocation> getAllServers() {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        GetAllServersRequest request = new GetAllServersRequest(this.serverGroup);
        GetAllServersResponse response = (GetAllServersResponse)this.queryLocators(request);
        if (response != null) {
            return response.getServers();
        }
        return null;
    }

    @Override
    public ServerLocation findReplacementServer(ServerLocation currentServer, Set excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientReplacementRequest request = new ClientReplacementRequest(currentServer, excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        return response.getServer();
    }

    @Override
    public ServerLocation findServer(Set excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientConnectionRequest request = new ClientConnectionRequest(excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        return response.getServer();
    }

    @Override
    public List findServersForQueue(Set excludedServers, int numServers, ClientProxyMembershipID proxyId, boolean findDurableQueue) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return new ArrayList();
        }
        QueueConnectionRequest request = new QueueConnectionRequest(proxyId, numServers, excludedServers, this.serverGroup, findDurableQueue);
        QueueConnectionResponse response = (QueueConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        List result = response.getServers();
        return result;
    }

    @Override
    public List<InetSocketAddress> getOnlineLocators() {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<InetSocketAddress>(this.onlineLocators.get().getLocators()));
    }

    private ServerLocationResponse queryOneLocator(HostAddress locator, ServerLocationRequest request) {
        Object returnObj = null;
        try {
            this.pool.getStats().incLocatorRequests();
            returnObj = this.tcpClient.requestToServer(locator.getSocketInetAddressNoLookup(), request, this.connectionTimeout, true);
            ServerLocationResponse response = (ServerLocationResponse)returnObj;
            this.pool.getStats().incLocatorResponses();
            if (response != null) {
                this.reportLiveLocator(locator.getSocketInetAddressNoLookup());
            }
            return response;
        }
        catch (IOException ioe) {
            this.reportDeadLocator(locator.getSocketInetAddressNoLookup(), ioe);
            this.updateLocatorInLocatorList(locator);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_RECEIVED_EXCEPTION_FROM_LOCATOR_0, locator), (Throwable)e);
            return null;
        }
        catch (ClassCastException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received odd response object from the locator: {}", returnObj);
            }
            this.reportDeadLocator(locator.getSocketInetAddressNoLookup(), e);
            return null;
        }
    }

    protected void updateLocatorInLocatorList(HostAddress locator) {
        if (locator.getSocketInetAddressNoLookup().getHostName() != null && !locator.isIpString()) {
            LocatorList locatorList = this.locators.get();
            ArrayList<HostAddress> newLocatorsList = new ArrayList<HostAddress>();
            for (HostAddress tloc : locatorList.getLocatorAddresses()) {
                if (tloc.equals(locator)) {
                    InetSocketAddress changeLoc = new InetSocketAddress(locator.getHostName(), locator.getSocketInetAddressNoLookup().getPort());
                    HostAddress hostAddress = new HostAddress(changeLoc, locator.getHostName());
                    newLocatorsList.add(hostAddress);
                    logger.info("updateLocatorInLocatorList changing locator list: loc form: " + locator + " ,loc to: " + changeLoc);
                    continue;
                }
                newLocatorsList.add(tloc);
            }
            logger.info("updateLocatorInLocatorList locator list from:" + locatorList.getLocators() + " to: " + newLocatorsList);
            LocatorList newLocatorList = new LocatorList(newLocatorsList);
            this.locators.set(newLocatorList);
        }
    }

    protected List<InetSocketAddress> getCurrentLocators() {
        return this.locators.get().getLocators();
    }

    protected ServerLocationResponse queryLocators(ServerLocationRequest request) {
        Iterator<HostAddress> controllerItr = this.locators.get().iterator();
        ServerLocationResponse response = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            HostAddress hostAddress = controllerItr.next();
            if (isDebugEnabled) {
                logger.debug("Sending query to locator {}: {}", (Object)hostAddress, (Object)request);
            }
            response = this.queryOneLocator(hostAddress, request);
            if (!isDebugEnabled) continue;
            logger.debug("Received query response from locator {}: {}", (Object)hostAddress, (Object)response);
        } while (controllerItr.hasNext() && (response == null || !response.hasResult()));
        if (response == null) {
            return null;
        }
        return response;
    }

    protected void updateLocatorList(LocatorListResponse response) {
        if (response == null) {
            return;
        }
        this.isBalanced = response.isBalanced();
        List<ServerLocation> locatorResponse = response.getLocators();
        ArrayList<HostAddress> newLocatorAddresses = new ArrayList<HostAddress>(locatorResponse.size());
        ArrayList<HostAddress> newOnlineLocators = new ArrayList<HostAddress>(locatorResponse.size());
        HashSet<HostAddress> badLocators = new HashSet<HostAddress>(this.initialLocators);
        for (ServerLocation locator : locatorResponse) {
            InetSocketAddress address = new InetSocketAddress(locator.getHostName(), locator.getPort());
            HostAddress hostAddress = new HostAddress(address, locator.getHostName());
            newLocatorAddresses.add(hostAddress);
            newOnlineLocators.add(hostAddress);
            badLocators.remove(hostAddress);
        }
        this.addbadLocators(newLocatorAddresses, badLocators);
        LocatorList newLocatorList = new LocatorList(newLocatorAddresses);
        if (logger.isInfoEnabled()) {
            List<InetSocketAddress> newLocators = newLocatorList.getLocators();
            LocatorList oldLocators = this.locators.get();
            ArrayList<InetSocketAddress> removedLocators = new ArrayList<InetSocketAddress>(oldLocators.getLocators());
            removedLocators.removeAll(newLocators);
            ArrayList<InetSocketAddress> addedLocators = new ArrayList<InetSocketAddress>(newLocators);
            addedLocators.removeAll(oldLocators.getLocators());
            if (!addedLocators.isEmpty()) {
                this.locatorCallback.locatorsDiscovered(Collections.unmodifiableList(addedLocators));
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_AUTOCONNECTIONSOURCE_DISCOVERED_NEW_LOCATORS_0, addedLocators));
            }
            if (!removedLocators.isEmpty()) {
                this.locatorCallback.locatorsRemoved(Collections.unmodifiableList(removedLocators));
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_AUTOCONNECTIONSOURCE_DROPPING_PREVIOUSLY_DISCOVERED_LOCATORS_0, removedLocators));
            }
        }
        this.locators.set(newLocatorList);
        this.onlineLocators.set(new LocatorList(newOnlineLocators));
        this.pool.getStats().setLocatorCount(newLocatorAddresses.size());
    }

    protected void addbadLocators(List<HostAddress> newLocators, Set<HostAddress> badLocators) {
        for (HostAddress badloc : badLocators) {
            boolean addIt = true;
            for (HostAddress goodloc : newLocators) {
                boolean isSameHost = badloc.getHostName().equals(goodloc.getHostName());
                if (!isSameHost || badloc.getPort() != goodloc.getPort()) continue;
                addIt = false;
                break;
            }
            if (!addIt) continue;
            newLocators.add(badloc);
        }
    }

    @Override
    public void start(InternalPool pool) {
        this.pool = pool;
        pool.getStats().setInitialContacts(this.locators.get().size());
        this.locatorUpdateInterval = Long.getLong("gemfire.LOCATOR_UPDATE_INTERVAL", pool.getPingInterval());
        if (this.locatorUpdateInterval > 0L) {
            pool.getBackgroundProcessor().scheduleWithFixedDelay(new UpdateLocatorListTask(), 0L, this.locatorUpdateInterval, TimeUnit.MILLISECONDS);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_UPDATE_LOCATOR_LIST_TASK_STARTED_WITH_INTERVAL_0, new Object[]{this.locatorUpdateInterval}));
        }
    }

    @Override
    public void stop() {
    }

    public void setLocatorDiscoveryCallback(LocatorDiscoveryCallback callback) {
        this.locatorCallback = callback;
    }

    private synchronized void reportLiveLocator(InetSocketAddress l) {
        Object prevState = this.locatorState.put(l, null);
        if (prevState != null) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_COMMUNICATION_HAS_BEEN_RESTORED_WITH_LOCATOR_0, l));
        }
    }

    private synchronized void reportDeadLocator(InetSocketAddress l, Exception ex) {
        Exception prevState = this.locatorState.put(l, ex);
        if (prevState == null) {
            if (ex instanceof ConnectException) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_LOCATOR_0_IS_NOT_RUNNING, l), (Throwable)ex);
            } else {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_COMMUNICATION_WITH_LOCATOR_0_FAILED_WITH_1, new Object[]{l, ex}), (Throwable)ex);
            }
        }
    }

    long getLocatorUpdateInterval() {
        return this.locatorUpdateInterval;
    }

    protected class UpdateLocatorListTask
    extends PoolImpl.PoolTask {
        protected UpdateLocatorListTask() {
        }

        @Override
        public void run2() {
            if (AutoConnectionSourceImpl.this.pool.getCancelCriterion().isCancelInProgress()) {
                return;
            }
            LocatorListResponse response = (LocatorListResponse)AutoConnectionSourceImpl.this.queryLocators(LOCATOR_LIST_REQUEST);
            AutoConnectionSourceImpl.this.updateLocatorList(response);
        }
    }

    private static class LocatorList {
        protected final List<HostAddress> locators;
        protected AtomicInteger currentLocatorIndex = new AtomicInteger();

        public LocatorList(List<HostAddress> locators) {
            Collections.sort(locators, SOCKET_ADDRESS_COMPARATOR);
            this.locators = Collections.unmodifiableList(locators);
        }

        public List<InetSocketAddress> getLocators() {
            ArrayList<InetSocketAddress> locs = new ArrayList<InetSocketAddress>();
            for (HostAddress la : this.locators) {
                locs.add(la.getSocketInetAddress());
            }
            return locs;
        }

        public List<HostAddress> getLocatorAddresses() {
            return this.locators;
        }

        public int size() {
            return this.locators.size();
        }

        public Iterator<HostAddress> iterator() {
            return new LocatorIterator();
        }

        public String toString() {
            return this.locators.toString();
        }

        protected class LocatorIterator
        implements Iterator<HostAddress> {
            private int startLocator;
            private int locatorNum;

            protected LocatorIterator() {
                this.startLocator = LocatorList.this.currentLocatorIndex.get();
                this.locatorNum = 0;
            }

            @Override
            public boolean hasNext() {
                return this.locatorNum < LocatorList.this.locators.size();
            }

            @Override
            public HostAddress next() {
                if (!this.hasNext()) {
                    return null;
                }
                int index = (this.locatorNum + this.startLocator) % LocatorList.this.locators.size();
                HostAddress nextLocator = LocatorList.this.locators.get(index);
                LocatorList.this.currentLocatorIndex.set(index);
                ++this.locatorNum;
                return nextLocator;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

